/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.api.mockers.TimeCost;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.core.intercept.AbstractSyncInterceptor;
import org.coodex.concrete.core.intercept.ConcreteInterceptor;
import org.coodex.concrete.core.intercept.MockV2Interceptor;
import org.coodex.concrete.core.intercept.annotations.ServerSide;
import org.coodex.util.Clock;
import org.coodex.util.Common;
import org.coodex.util.ServiceLoader;
import org.coodex.util.ServiceLoaderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerSide
public class TimeCostInterceptor
extends AbstractSyncInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TimeCostInterceptor.class);
    private Boolean accept = null;
    private static ServiceLoader<ConcreteInterceptor> loader = new ServiceLoaderImpl<ConcreteInterceptor>(){

        protected ConcreteInterceptor conflict(Class<? extends ConcreteInterceptor> providerClass, Map<String, ConcreteInterceptor> map) {
            return map.values().iterator().next();
        }
    };

    protected boolean accept_(DefinitionContext context) {
        if (this.accept == null) {
            try {
                this.accept = loader.get(MockV2Interceptor.class) != null;
            }
            catch (Throwable th) {
                log.warn(th.getLocalizedMessage(), th);
                this.accept = false;
            }
        }
        return this.accept;
    }

    public Object around(DefinitionContext context, MethodInvocation joinPoint) throws Throwable {
        long now = Clock.currentTimeMillis();
        long cost = 0L;
        TimeCost timeCost = (TimeCost)context.getAnnotation(TimeCost.class);
        if (timeCost != null) {
            cost = Common.random((int)Math.min(timeCost.min(), timeCost.max()), (int)Math.max(timeCost.min(), timeCost.max()));
        }
        Object object = super.around(context, joinPoint);
        long used = Clock.currentTimeMillis() - now;
        if (cost > used) {
            Thread.sleep(cost - used);
        }
        return object;
    }

    public int getOrder() {
        return 101;
    }
}

