/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.spring.aspects;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;

public class AspectJHelper {
    public static final String ASPECT_POINT = "target(org.coodex.concrete.api.ConcreteService) && execution(public * *(..))";

    protected static final Method getMethod(Signature sign) {
        return ((MethodSignature)sign).getMethod();
    }

    static MethodInvocation proceedJoinPointToMethodInvocation(ProceedingJoinPoint joinPoint) {
        return new ProceedJoinPointToMethodInvocation(joinPoint);
    }

    private static class ProceedJoinPointToMethodInvocation
    implements MethodInvocation {
        private ProceedingJoinPoint joinPoint;
        private Method method = null;

        ProceedJoinPointToMethodInvocation(ProceedingJoinPoint joinPoint) {
            this.joinPoint = joinPoint;
        }

        public synchronized Method getMethod() {
            if (this.method == null) {
                this.method = AspectJHelper.getMethod(this.joinPoint.getSignature());
                int paramCount = this.method.getParameterTypes().length;
                for (Method m : this.getThis().getClass().getMethods()) {
                    if (!m.getName().equals(this.method.getName()) || m.getParameterTypes().length != paramCount) continue;
                    this.method = m;
                    break;
                }
            }
            return this.method;
        }

        public Object[] getArguments() {
            return this.joinPoint.getArgs();
        }

        public Object proceed() throws Throwable {
            return this.joinPoint.proceed();
        }

        public Object getThis() {
            return this.joinPoint.getTarget();
        }

        public AccessibleObject getStaticPart() {
            return null;
        }
    }
}

