/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.spring.components;

import java.lang.reflect.Type;
import javax.inject.Named;
import org.coodex.concrete.message.AbstractTopic;
import org.coodex.concrete.message.GenericTypeHelper;
import org.coodex.concrete.message.MessageConsumer;
import org.coodex.concrete.message.Observer;
import org.coodex.concrete.message.Topic;
import org.coodex.concrete.message.Topics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;

@Named
public class MessageObserverBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter {
    private static final Logger log = LoggerFactory.getLogger(MessageObserverBeanPostProcessor.class);

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Observer) {
            Observer observer = (Observer)bean;
            this.getTopic(observer, beanName).subscribe(observer);
        }
        return super.postProcessAfterInitialization(bean, beanName);
    }

    private AbstractTopic getTopic(Observer observer, String beanName) {
        MessageConsumer messageConsumer = observer.getClass().getAnnotation(MessageConsumer.class);
        Type topicType = null;
        String queue = null;
        Type messageType = GenericTypeHelper.solve(Observer.class.getTypeParameters()[0], observer.getClass());
        Class topicClass = messageConsumer == null ? Topic.class : messageConsumer.topicType();
        queue = messageConsumer == null ? null : messageConsumer.queue();
        topicType = topicClass.equals(Topic.class) || topicClass.equals(AbstractTopic.class) ? GenericTypeHelper.buildParameterizedType(Topic.class, (Type[])new Type[]{messageType}) : topicClass;
        log.debug("{} subscribe {}, {}", new Object[]{topicType, beanName, observer.getClass().getName()});
        return Topics.get((Type)topicType, (String)queue);
    }
}

