/*
 * Copyright (c) 2018 coodex.org (jujus.shen@126.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.coodex.concrete.spring;

import org.coodex.count.Segmentation;
import org.coodex.util.Clock;
import org.springframework.scheduling.support.CronSequenceGenerator;

import java.util.Calendar;

/**
 * @see org.springframework.scheduling.support.CronSequenceGenerator
 * Created by davidoff shen on 2017-04-19.
 */
public class SpecificMomentSegmentation implements Segmentation {

    private final CronSequenceGenerator cronSequenceGenerator;

    public SpecificMomentSegmentation(String cron) {
        this.cronSequenceGenerator = new CronSequenceGenerator(cron);
    }

    @Override
    public long next() {
        return cronSequenceGenerator.next(Clock.getCalendar().getTime()).getTime();
    }

}
