/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.spring;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.coodex.concrete.common.BeanProvider;
import org.coodex.concrete.common.Caller;
import org.coodex.concrete.common.CallerWrapper;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.common.SubjoinWrapper;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.intercept.BeanValidationInterceptor;
import org.coodex.concrete.core.intercept.ConcreteInterceptor;
import org.coodex.concrete.core.intercept.LimitingInterceptor;
import org.coodex.concrete.core.intercept.OperationLogInterceptor;
import org.coodex.concrete.core.intercept.RBACInterceptor;
import org.coodex.concrete.core.intercept.ServiceTimingInterceptor;
import org.coodex.concrete.core.intercept.SignatureInterceptor;
import org.coodex.concrete.core.token.TokenWrapper;
import org.coodex.concrete.spring.InterceptorLoader;
import org.coodex.concrete.spring.SpringBeanProvider;
import org.coodex.config.Config;
import org.coodex.util.ServiceLoader;
import org.coodex.util.ServiceLoaderImpl;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"org.coodex.concrete.spring.components", "org.coodex.concrete.**.injectable"})
public class ConcreteSpringConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ConcreteSpringConfiguration.class);
    private static Singleton<ServiceLoader<InterceptorLoader>> INTERCEPTOR_LOADER = new Singleton(() -> new ServiceLoaderImpl<InterceptorLoader>(ConcreteSpringConfiguration::getInterceptorSupportedMap){});

    @Bean
    public BeanProvider springBeanProvider() {
        return new SpringBeanProvider();
    }

    @Bean
    public Token tokenWrapper() {
        return TokenWrapper.getInstance();
    }

    @Bean
    public Caller callerWrapper() {
        return CallerWrapper.getInstance();
    }

    @Bean
    public Subjoin subjoinWrapper() {
        return SubjoinWrapper.getInstance();
    }

    private static Map<String, Class<? extends ConcreteInterceptor>> getInterceptorSupportedMap() {
        return new HashMap<String, Class<? extends ConcreteInterceptor>>(){
            {
                this.put("rbac", RBACInterceptor.class);
                this.put("limiting", LimitingInterceptor.class);
                this.put("signature", SignatureInterceptor.class);
                this.put("log", OperationLogInterceptor.class);
                this.put("timing", ServiceTimingInterceptor.class);
                this.put("beanValidation", BeanValidationInterceptor.class);
            }
        };
    }

    @Bean
    public Set<ConcreteInterceptor> interceptors() {
        HashSet<ConcreteInterceptor> set = new HashSet<ConcreteInterceptor>();
        for (Map.Entry<String, Class<? extends ConcreteInterceptor>> entry : ((InterceptorLoader)((ServiceLoader)INTERCEPTOR_LOADER.get()).get()).getInterceptorSupportedMap().entrySet()) {
            if (!((Boolean)Config.getValue((String)("interceptors." + entry.getKey()), (Object)false, (String[])new String[]{"concrete", ConcreteHelper.getAppSet()})).booleanValue()) continue;
            try {
                set.add(entry.getValue().newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.warn("load interceptor {}[{}] failed.", (Object)entry.getKey(), (Object)entry.getValue().getName());
            }
        }
        return set;
    }
}

