/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.spring.components;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.inject.Inject;
import javax.inject.Named;
import org.coodex.concrete.common.bytecode.javassist.JavassistHelper;
import org.coodex.concrete.message.AbstractTopic;
import org.coodex.concrete.message.Queue;
import org.coodex.concrete.message.TopicKey;
import org.coodex.concrete.message.Topics;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;
import org.coodex.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

@Named
public class TopicBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter {
    private static final Logger log = LoggerFactory.getLogger(TopicBeanPostProcessor.class);
    private static AtomicLong index = new AtomicLong(0L);
    private Set<TopicKey> injected = new HashSet<TopicKey>();
    @Inject
    private DefaultListableBeanFactory defaultListableBeanFactory;
    private Class<? extends Annotation>[] injectableAnnotations = new Class[]{Inject.class};

    private boolean isInjectable(Field field) {
        for (Class<? extends Annotation> clz : this.injectableAnnotations) {
            if (field.getAnnotation(clz) == null) continue;
            return true;
        }
        return false;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        this.scan(bean, bean.getClass(), beanName);
        return super.postProcessAfterInstantiation(bean, beanName);
    }

    private boolean isTopic(Field field) {
        Class<?> c = field.getType();
        return c.isInterface() && AbstractTopic.class.isAssignableFrom(c);
    }

    private void scan(Object bean, Class<?> beanClass, String beanName) {
        for (Field field : ReflectHelper.getAllDeclaredFields(beanClass)) {
            if (!this.isTopic(field)) continue;
            Queue queue = field.getAnnotation(Queue.class);
            String queueName = queue == null ? null : queue.value();
            Type topicType = GenericTypeHelper.toReference((Type)field.getGenericType(), beanClass);
            if (this.isInjectable(field)) {
                this.registerBean(topicType, queueName, beanClass);
                continue;
            }
            AbstractTopic topic = Topics.get((Type)topicType, (String)queueName);
            try {
                field.setAccessible(true);
                field.set(bean, topic);
                log.warn("{} {} {} injected. use @Inject plz.", new Object[]{beanName, topicType, field.getName()});
            }
            catch (Throwable e) {
                throw Common.runtimeException((Throwable)e);
            }
        }
    }

    private javassist.bytecode.annotation.Annotation queue(String queueName, ConstPool constPool) {
        javassist.bytecode.annotation.Annotation annotation = new javassist.bytecode.annotation.Annotation(Queue.class.getName(), constPool);
        annotation.addMemberValue("value", (MemberValue)new StringMemberValue(queueName, constPool));
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerBean(Type topicType, String queueName, Class<?> contextClass) {
        block6: {
            try {
                TopicKey topicKey = new TopicKey(queueName, topicType);
                if (this.injected.contains(topicKey)) break block6;
                TopicBeanPostProcessor topicBeanPostProcessor = this;
                synchronized (topicBeanPostProcessor) {
                    if (!this.injected.contains(topicKey)) {
                        String beanName = "topic_" + Common.getUUIDStr();
                        String cName = String.format("TopicBean$$CBC$$%08X", index.incrementAndGet());
                        String className = String.format("%s.%s", contextClass.getPackage().getName(), cName);
                        ParameterizedType pt = (ParameterizedType)topicType;
                        Class<?> clz = this.getBeanClass(topicType, queueName, className, pt, contextClass);
                        this.defaultListableBeanFactory.registerSingleton(beanName, clz.getConstructor(new Class[0]).newInstance(new Object[0]));
                        log.info("Topic Bean registered: {}, {}, {}, {}. ", new Object[]{beanName, queueName, topicType.toString(), clz.getName()});
                        this.injected.add(topicKey);
                    }
                }
            }
            catch (Throwable th) {
                throw Common.runtimeException((Throwable)th);
            }
        }
    }

    private Class<?> getBeanClass(Type topicType, String queueName, String className, ParameterizedType pt, Class<?> contextClass) throws CannotCompileException {
        ClassPool classPool = JavassistHelper.getClassPool(TopicBeanPostProcessor.class);
        CtClass ctClass = classPool.makeClass(className);
        ctClass.setInterfaces(new CtClass[]{classPool.getOrNull(((Class)pt.getRawType()).getName())});
        ClassFile classFile = ctClass.getClassFile();
        classFile.setVersionToJava5();
        ConstPool constPool = classFile.getConstPool();
        String sig = new SignatureAttribute.ClassSignature(null, null, new SignatureAttribute.ClassType[]{JavassistHelper.classType((String)((Class)pt.getRawType()).getName(), (Type[])new Type[]{pt.getActualTypeArguments()[0]})}).encode();
        ctClass.setGenericSignature(sig);
        if (queueName != null) {
            classFile.addAttribute((AttributeInfo)JavassistHelper.aggregate((ConstPool)constPool, (javassist.bytecode.annotation.Annotation[])new javassist.bytecode.annotation.Annotation[]{this.queue(queueName, constPool)}));
        }
        ctClass.addField(CtField.make((String)"private boolean queueLoaded = false;", (CtClass)ctClass));
        ctClass.addField(CtField.make((String)"private String queueName = null;", (CtClass)ctClass));
        ctClass.addMethod(CtMethod.make((String)"private synchronized String getQueueName() {\n    if (!queueLoaded) {\n        org.coodex.concrete.message.Queue queue =\n                getClass().getAnnotation(org.coodex.concrete.message.Queue.class);\n        queueName = queue == null ? null : queue.value();\n        queueLoaded = true;\n    }\n    return queueName;\n}", (CtClass)ctClass));
        ctClass.addField(CtField.make((String)"private java.lang.reflect.Type topicType = null;", (CtClass)ctClass));
        ctClass.addMethod(CtMethod.make((String)"private synchronized java.lang.reflect.Type getTopicType(){\n    if(topicType == null){\n       topicType = getClass().getGenericInterfaces()[0];\n    }\n    return topicType;\n}", (CtClass)ctClass));
        for (Method method : ((Class)pt.getRawType()).getMethods()) {
            boolean voidReturn = method.getReturnType().equals(Void.TYPE);
            CtMethod ctMethod = new CtMethod(voidReturn ? CtClass.voidType : classPool.getOrNull(method.getReturnType().getName()), method.getName(), JavassistHelper.toCtClass((Class[])method.getParameterTypes(), (ClassPool)classPool), ctClass);
            ArrayList<SignatureAttribute.Type> parameters = new ArrayList<SignatureAttribute.Type>();
            for (int i = 0; i < method.getGenericParameterTypes().length; ++i) {
                parameters.add(JavassistHelper.classType((Type)GenericTypeHelper.toReference((Type)method.getGenericParameterTypes()[i], (Type)topicType), contextClass));
            }
            ctMethod.setGenericSignature(new SignatureAttribute.MethodSignature(null, parameters.toArray(new SignatureAttribute.Type[0]), voidReturn ? null : JavassistHelper.classType((Type)GenericTypeHelper.toReference((Type)method.getGenericReturnType(), (Type)topicType), contextClass), null).encode());
            StringBuilder body = new StringBuilder();
            body.append('{');
            if (!voidReturn) {
                body.append("return ");
            }
            body.append("((").append(((Class)pt.getRawType()).getName()).append(")org.coodex.concrete.message.Topics.get(getTopicType(), getQueueName())).");
            body.append(method.getName()).append('(');
            if (method.getParameterTypes().length > 0) {
                body.append("$$");
            }
            body.append(");");
            body.append("}");
            ctMethod.setBody(body.toString());
            ctClass.addMethod(ctMethod);
        }
        return (Boolean)JavassistHelper.IS_JAVA_9_AND_LAST.get() != false ? ctClass.toClass(contextClass) : ctClass.toClass();
    }
}

