/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.spring;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.coodex.concrete.common.AbstractBeanProvider;
import org.coodex.concrete.core.intercept.ConcreteInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringBeanProvider
extends AbstractBeanProvider
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringBeanProvider.class);
    private static ApplicationContext context = null;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type) {
        if (context == null) {
            log.info("spring bean provider not initialized, {} not load from spring bean provider.", (Object)type.getName());
            return new HashMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>(context.getBeansOfType(type));
        for (Class c : this.collectionBeanTypes()) {
            if (!c.isAssignableFrom(type)) continue;
            Class<?> arrayClass = Array.newInstance(type, 0).getClass();
            Map x = context.getBeansOfType(arrayClass);
            if (x != null && x.size() > 0) {
                int index = 0;
                for (Map.Entry entry : x.entrySet()) {
                    if (entry.getValue() == null) continue;
                    int len = Array.getLength(entry.getValue());
                    for (int l = 0; l < len; ++l) {
                        String key = (String)entry.getKey() + "_array_" + index;
                        map.put(key, Array.get(entry.getValue(), l));
                        ++index;
                    }
                }
                if (index > 0) {
                    log.info("load {} {} bean(s) in array beans.", (Object)index, (Object)c.getName());
                }
            }
            Map collectionBeans = context.getBeansOfType(Collection.class);
            for (Map.Entry entry : collectionBeans.entrySet()) {
                int index = 0;
                if (entry.getValue() == null || ((Collection)entry.getValue()).size() == 0) continue;
                for (Object o : (Collection)entry.getValue()) {
                    if (o == null || !c.isAssignableFrom(o.getClass())) continue;
                    String key = (String)entry.getKey() + "_collection_" + index;
                    map.put(key, o);
                    ++index;
                }
                if (index <= 0) continue;
                log.info("load {} {} bean(s) in collection beans.", (Object)index, (Object)c.getName());
            }
        }
        return map;
    }

    protected Class[] collectionBeanTypes() {
        return new Class[]{ConcreteInterceptor.class};
    }
}

