/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.spring.components;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicLong;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.ConstPool;
import javassist.bytecode.SignatureAttribute;
import javax.inject.Inject;
import org.coodex.concrete.common.bytecode.javassist.JavassistHelper;
import org.coodex.concrete.spring.components.InjectInfoKey;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.Primary;

public abstract class AbstractInjectableBeanPostProcessor<K extends InjectInfoKey>
extends InstantiationAwareBeanPostProcessorAdapter {
    private static final Logger log = LoggerFactory.getLogger(AbstractInjectableBeanPostProcessor.class);
    private static AtomicLong index = new AtomicLong(0L);
    @Inject
    private DefaultListableBeanFactory defaultListableBeanFactory;
    private Class<? extends Annotation>[] injectableAnnotations = new Class[]{Autowired.class, Inject.class};
    private Map<InjectInfoKey, Class<?>> injectedCache = new HashMap();

    protected boolean isInjectable(Field field) {
        for (Class<? extends Annotation> clz : this.injectableAnnotations) {
            if (field.getAnnotation(clz) == null) continue;
            return true;
        }
        return false;
    }

    protected long getIndex() {
        return index.incrementAndGet();
    }

    protected javassist.bytecode.annotation.Annotation primary(ConstPool constPool) {
        return new javassist.bytecode.annotation.Annotation(Primary.class.getName(), constPool);
    }

    public final boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        this.scan(bean, bean.getClass(), beanName, bean.getClass());
        return super.postProcessAfterInstantiation(bean, beanName);
    }

    protected abstract boolean accept(Field var1);

    protected abstract Class<?> getInjectClass(K var1, Class<?> var2);

    protected abstract String newBeanName();

    protected abstract K getKey(Class<?> var1, Field var2);

    protected boolean injectNoneAnnotation() {
        return false;
    }

    protected void buildMethods(ClassPool classPool, CtClass ctClass, Class<?> proxyClass, Type injectType, Class<?> contextClass, String instanceGetter) throws CannotCompileException {
        for (Method method : proxyClass.getMethods()) {
            boolean voidReturn = method.getReturnType().equals(Void.TYPE);
            CtMethod ctMethod = new CtMethod(voidReturn ? CtClass.voidType : classPool.getOrNull(method.getReturnType().getName()), method.getName(), JavassistHelper.toCtClass((Class[])method.getParameterTypes(), (ClassPool)classPool), ctClass);
            ArrayList<SignatureAttribute.Type> parameters = new ArrayList<SignatureAttribute.Type>();
            for (int i = 0; i < method.getGenericParameterTypes().length; ++i) {
                parameters.add(JavassistHelper.classType(method.getParameterTypes()[i].equals(Class.class) ? Class.class : GenericTypeHelper.toReference((Type)method.getGenericParameterTypes()[i], (Type)injectType), contextClass));
            }
            ctMethod.setGenericSignature(new SignatureAttribute.MethodSignature(null, parameters.toArray(new SignatureAttribute.Type[0]), voidReturn ? null : JavassistHelper.classType((Type)GenericTypeHelper.toReference((Type)method.getGenericReturnType(), (Type)injectType), contextClass), null).encode());
            StringBuilder body = new StringBuilder();
            body.append('{');
            if (!voidReturn) {
                body.append("return ");
            }
            body.append("((").append(proxyClass.getName()).append(")").append(instanceGetter).append(")").append(".");
            body.append(method.getName()).append('(');
            if (method.getParameterTypes().length > 0) {
                body.append("$$");
            }
            body.append(");");
            body.append("}");
            ctMethod.setBody(body.toString());
            ctClass.addMethod(ctMethod);
        }
    }

    private synchronized void scan(Object bean, Class<?> beanClass, String beanName, Class<?> scanClass) {
        if (Object.class.equals(scanClass)) {
            return;
        }
        for (Field field : scanClass.getDeclaredFields()) {
            K key;
            if (!this.accept(field)) continue;
            if (bean == null) {
                log.debug("process {} {}: {} extends {}", new Object[]{GenericTypeHelper.toReference((Type)field.getGenericType(), beanClass), field.getName(), beanClass.getName(), scanClass.getName()});
            }
            if (!this.injectedCache.containsKey(key = this.getKey(beanClass, field))) {
                Class<?> injectClass = this.getInjectClass(key, beanClass);
                String newBeanName = this.newBeanName();
                RootBeanDefinition beanDefinition = new RootBeanDefinition(injectClass);
                if (injectClass.getAnnotation(Primary.class) != null) {
                    beanDefinition.setPrimary(true);
                }
                this.getDefaultListableBeanFactory().registerBeanDefinition(newBeanName, (BeanDefinition)beanDefinition);
                if (log.isInfoEnabled()) {
                    StringJoiner joiner = new StringJoiner(", ");
                    Arrays.stream(injectClass.getGenericInterfaces()).map(type -> GenericTypeHelper.toReference((Type)type, (Type)injectClass)).forEach(type -> joiner.add(type.toString()));
                    String interfaces = joiner.length() > 0 ? " implements " + joiner.toString() : "";
                    log.info("new bean registered: {}, {} extends {}{}", new Object[]{newBeanName, injectClass.getName(), GenericTypeHelper.toReference((Type)injectClass.getGenericSuperclass(), injectClass), interfaces});
                }
                this.injectedCache.put((InjectInfoKey)key, injectClass);
            }
            if (bean == null) continue;
            if (this.isInjectable(field)) {
                log.info("{} {} {} injected.", new Object[]{beanName, GenericTypeHelper.toReference((Type)field.getGenericType(), beanClass), field.getName()});
                continue;
            }
            if (!this.injectNoneAnnotation()) continue;
            try {
                field.setAccessible(true);
                field.set(bean, this.injectedCache.get(key).newInstance());
                log.warn("{} {} {} injected. use @Inject plz.", new Object[]{beanName, GenericTypeHelper.toReference((Type)field.getGenericType(), beanClass), field.getName()});
            }
            catch (Throwable e) {
                throw Common.runtimeException((Throwable)e);
            }
        }
        this.scan(bean, beanClass, beanName, scanClass.getSuperclass());
    }

    protected DefaultListableBeanFactory getDefaultListableBeanFactory() {
        return this.defaultListableBeanFactory;
    }
}

