/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.spring.components;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.inject.Named;
import org.coodex.concrete.common.bytecode.javassist.JavassistHelper;
import org.coodex.concrete.message.AbstractTopic;
import org.coodex.concrete.message.Queue;
import org.coodex.concrete.message.TopicKey;
import org.coodex.concrete.spring.components.AbstractInjectableBeanPostProcessor;
import org.coodex.concrete.spring.components.InjectInfoKey;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class TopicBeanPostProcessor
extends AbstractInjectableBeanPostProcessor<InjectTopicKey> {
    private static final Logger log = LoggerFactory.getLogger(TopicBeanPostProcessor.class);
    private Set<TopicKey> injected = new HashSet<TopicKey>();

    private boolean isTopic(Field field) {
        Class<?> c = field.getType();
        return c.isInterface() && AbstractTopic.class.isAssignableFrom(c);
    }

    @Override
    protected boolean accept(Field field) {
        return this.isTopic(field);
    }

    @Override
    protected Class<?> getInjectClass(InjectTopicKey key, Class<?> beanClass) {
        String cName = String.format("TopicBean$$CBC$$%08X", this.getIndex());
        String className = String.format("%s.%s", TopicBeanPostProcessor.class.getPackage().getName(), cName);
        ParameterizedType pt = (ParameterizedType)key.getTopicType();
        try {
            Class<?> clz = this.getBeanClass(key.getTopicType(), key.getThisQueue(), className, pt, beanClass);
            log.info("Topic Bean Class created: {}, {}, {}. ", new Object[]{key.getQueue(), key.getTopicType().toString(), clz.getName()});
            return clz;
        }
        catch (Throwable th) {
            throw Common.runtimeException((Throwable)th);
        }
    }

    @Override
    protected String newBeanName() {
        return "topic_" + Common.getUUIDStr();
    }

    private String getQueueName(Field field) {
        Queue queue = field.getAnnotation(Queue.class);
        return queue == null ? null : queue.value();
    }

    private Type getTopicType(Field field, Class<?> beanClass) {
        return GenericTypeHelper.toReference((Type)field.getGenericType(), beanClass);
    }

    @Override
    @Deprecated
    protected boolean injectNoneAnnotation() {
        return true;
    }

    @Override
    protected InjectTopicKey getKey(Class<?> beanClass, Field field) {
        return new InjectTopicKey(this.getQueueName(field), this.getTopicType(field, beanClass));
    }

    private Annotation queue(String queueName, ConstPool constPool) {
        Annotation annotation = new Annotation(Queue.class.getName(), constPool);
        annotation.addMemberValue("value", (MemberValue)new StringMemberValue(queueName, constPool));
        return annotation;
    }

    private Class<?> getBeanClass(Type topicType, String queueName, String className, ParameterizedType pt, Class<?> contextClass) throws CannotCompileException {
        ClassPool classPool = JavassistHelper.getClassPool(TopicBeanPostProcessor.class);
        CtClass ctClass = classPool.makeClass(className);
        ctClass.setInterfaces(new CtClass[]{classPool.getOrNull(((Class)pt.getRawType()).getName())});
        ClassFile classFile = ctClass.getClassFile();
        classFile.setVersionToJava5();
        ConstPool constPool = classFile.getConstPool();
        String sig = new SignatureAttribute.ClassSignature(null, null, new SignatureAttribute.ClassType[]{JavassistHelper.classType((String)((Class)pt.getRawType()).getName(), (Type[])new Type[]{pt.getActualTypeArguments()[0]})}).encode();
        ctClass.setGenericSignature(sig);
        if (queueName != null) {
            classFile.addAttribute((AttributeInfo)JavassistHelper.aggregate((ConstPool)constPool, (Annotation[])new Annotation[]{this.queue(queueName, constPool)}));
        } else {
            classFile.addAttribute((AttributeInfo)JavassistHelper.aggregate((ConstPool)constPool, (Annotation[])new Annotation[]{this.primary(constPool)}));
        }
        ctClass.addField(CtField.make((String)"private boolean queueLoaded = false;", (CtClass)ctClass));
        ctClass.addField(CtField.make((String)"private String queueName = null;", (CtClass)ctClass));
        ctClass.addMethod(CtMethod.make((String)"private synchronized String getQueueName() {\n    if (!queueLoaded) {\n        org.coodex.concrete.message.Queue queue =\n                getClass().getAnnotation(org.coodex.concrete.message.Queue.class);\n        queueName = queue == null ? null : queue.value();\n        queueLoaded = true;\n    }\n    return queueName;\n}", (CtClass)ctClass));
        ctClass.addField(CtField.make((String)"private java.lang.reflect.Type topicType = null;", (CtClass)ctClass));
        ctClass.addMethod(CtMethod.make((String)"private synchronized java.lang.reflect.Type getTopicType(){\n    if(topicType == null){\n       topicType = getClass().getGenericInterfaces()[0];\n    }\n    return topicType;\n}", (CtClass)ctClass));
        this.buildMethods(classPool, ctClass, (Class)pt.getRawType(), topicType, contextClass, "org.coodex.concrete.message.Topics.get(getTopicType(), getQueueName())");
        return (Boolean)JavassistHelper.IS_JAVA_9_AND_LAST.get() != false ? ctClass.toClass(TopicBeanPostProcessor.class) : ctClass.toClass();
    }

    public static class InjectTopicKey
    extends TopicKey
    implements InjectInfoKey {
        private final String thisQueue;

        public InjectTopicKey(String queue, Type topicType) {
            super(queue, topicType);
            this.thisQueue = queue;
        }

        public String getThisQueue() {
            return this.thisQueue;
        }
    }
}

