/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.spring;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.config.Config;
import org.coodex.util.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationAttributes;

public abstract class AbstractRuntimeParameter {
    private static final Logger log = LoggerFactory.getLogger(AbstractRuntimeParameter.class);
    private String[] apiPackages;
    private Class[] classes;

    public AbstractRuntimeParameter(String[] apiPackages, Class[] classes) {
        this.apiPackages = apiPackages;
        this.classes = classes;
    }

    public String[] getApiPackages() {
        return this.toRegisteredPackages(this.apiPackages);
    }

    private String[] toRegisteredPackages(String[] packages) {
        return packages == null || packages.length == 0 ? new HashSet<String>(Arrays.asList(ConcreteHelper.getApiPackages((String)this.getNamespace()))).toArray(new String[0]) : packages;
    }

    public Class[] getClasses() {
        return this.toRegistered(this.classes);
    }

    private Class[] toRegistered(Class[] classes) {
        return classes == null || classes.length == 0 ? this.toRegistered().toArray(new Class[0]) : classes;
    }

    private Set<Class> toRegistered() {
        HashSet<Class> classes = new HashSet<Class>();
        for (String str : Config.getArray((String)(this.getNamespace() + ".classes"), (String)",", (String[])new String[0], (String[])new String[]{"concrete", this.getNamespace()})) {
            try {
                classes.add(Class.forName(str));
            }
            catch (ClassNotFoundException e) {
                log.info("registered failed. class not found: {}", (Object)str);
            }
        }
        return classes;
    }

    protected <T> T get(String key, T defaultValue) {
        String s = Config.get((String)(this.getNamespace() + "." + key), (String[])new String[]{"concrete", this.getNamespace(), ConcreteHelper.getAppSet()});
        return (T)(s == null ? defaultValue : Common.to((String)s, defaultValue));
    }

    protected abstract String getNamespace();

    protected abstract void loadCustomRuntimeConfigFrom(AnnotationAttributes var1);

    public final void loadFrom(AnnotationAttributes annotationAttributes) {
        this.apiPackages = annotationAttributes.getStringArray("servicePackages");
        this.classes = annotationAttributes.getClassArray("classes");
        this.loadCustomRuntimeConfigFrom(annotationAttributes);
    }
}

