/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.spring.components;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javax.inject.Named;
import org.coodex.concrete.common.bytecode.javassist.JavassistHelper;
import org.coodex.concrete.spring.components.AbstractInjectableBeanPostProcessor;
import org.coodex.concrete.spring.components.ServiceLoaderKey;
import org.coodex.util.Common;
import org.coodex.util.DefaultService;
import org.coodex.util.GenericTypeHelper;
import org.coodex.util.ServiceLoader;
import org.coodex.util.ServiceLoaderImpl;

@Named
public class ServiceLoaderBeanPostProcessor
extends AbstractInjectableBeanPostProcessor<ServiceLoaderKey> {
    static Map<String, ServiceLoader> cache = new HashMap<String, ServiceLoader>();

    static Annotation spiAnnotation(Class<?> defaultService, ConstPool constPool) {
        Annotation annotation = new Annotation(DefaultService.class.getName(), constPool);
        annotation.addMemberValue("value", (MemberValue)new ClassMemberValue(defaultService.getName(), constPool));
        return annotation;
    }

    static Class<?> getDefaultServiceClass(AnnotatedElement annotatedElement) {
        DefaultService defaultService = annotatedElement.getAnnotation(DefaultService.class);
        return defaultService == null ? null : defaultService.value();
    }

    @Override
    protected boolean accept(Field field) {
        return ServiceLoader.class.equals(field.getType());
    }

    @Override
    protected Class<?> getInjectClass(ServiceLoaderKey key, Class<?> beanClass) {
        try {
            String className = ServiceLoaderBeanPostProcessor.class.getPackage().getName() + "." + String.format("ServiceLoaderBean$$CBC$$%08X", this.getIndex());
            final Type serviceType = GenericTypeHelper.toReference(ServiceLoader.class.getTypeParameters()[0], (Type)key.getServiceType());
            try {
                final Object defaultService = key.getDefaultServiceClass() == null ? null : (Throwable.class.isAssignableFrom(key.getDefaultServiceClass()) ? Proxy.newProxyInstance(ServiceLoaderBeanPostProcessor.class.getClassLoader(), new Class[]{GenericTypeHelper.typeToClass((Type)serviceType)}, (proxy, method, args) -> {
                    throw new RuntimeException("no default service found for: " + serviceType.toString());
                }) : (Object)key.getDefaultServiceClass().newInstance());
                cache.put(className, (ServiceLoader)new ServiceLoaderImpl(){

                    protected Class getInterfaceClass() {
                        return GenericTypeHelper.typeToClass((Type)serviceType);
                    }

                    public Object getDefault() {
                        return defaultService;
                    }
                });
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            ClassPool classPool = JavassistHelper.getClassPool(ServiceLoaderBeanPostProcessor.class);
            CtClass ctClass = classPool.makeClass(className);
            ctClass.setInterfaces(new CtClass[]{classPool.getOrNull(ServiceLoader.class.getName())});
            ClassFile classFile = ctClass.getClassFile();
            classFile.setVersionToJava5();
            ConstPool constPool = classFile.getConstPool();
            String sig = new SignatureAttribute.ClassSignature(null, null, new SignatureAttribute.ClassType[]{JavassistHelper.classType((String)ServiceLoader.class.getName(), (Type[])new Type[]{serviceType})}).encode();
            ctClass.setGenericSignature(sig);
            this.buildMethods(classPool, ctClass, ServiceLoader.class, key.getServiceType(), beanClass, ServiceLoaderBeanPostProcessor.class.getName() + ".cache.get(this.getClass().getName())");
            if (key.getDefaultServiceClass() != null) {
                classFile.addAttribute((AttributeInfo)JavassistHelper.aggregate((ConstPool)constPool, (Annotation[])new Annotation[]{ServiceLoaderBeanPostProcessor.spiAnnotation(key.getDefaultServiceClass(), constPool)}));
            } else {
                classFile.addAttribute((AttributeInfo)JavassistHelper.aggregate((ConstPool)constPool, (Annotation[])new Annotation[]{this.primary(constPool)}));
            }
            return (Boolean)JavassistHelper.IS_JAVA_9_AND_LAST.get() != false ? ctClass.toClass(ServiceLoaderBeanPostProcessor.class) : ctClass.toClass();
        }
        catch (CannotCompileException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String newBeanName() {
        return "ServiceLoader_" + Common.getUUIDStr();
    }

    @Override
    protected ServiceLoaderKey getKey(Class<?> beanClass, Field field) {
        return new ServiceLoaderKey(ServiceLoaderBeanPostProcessor.getDefaultServiceClass(field), GenericTypeHelper.toReference((Type)field.getGenericType(), beanClass));
    }
}

