/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.util.Map;
import org.coodex.concrete.common.BeanProvider;
import org.coodex.concrete.common.BeanProviderFacade;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ConcreteSPIFacade;
import org.coodex.concrete.common.ConflictSolution;
import org.coodex.concrete.common.conflictsolutions.ThrowException;

public abstract class AbstractBeanProvider
implements BeanProvider {
    private static final ConflictSolution DEFAULT_CONFLICT_SOLUTION = new ThrowException();
    private static final ConcreteSPIFacade<ConflictSolution> SOLUTION_CONCRETE_SPI_FACADE = new ConcreteSPIFacade<ConflictSolution>(){};

    private static final ConflictSolution getSolution(Class<?> clz) {
        try {
            Map<String, ConflictSolution> map = BeanProviderFacade.getBeanProvider().getBeansOfType(ConflictSolution.class);
            if (map != null) {
                for (ConflictSolution solution : map.values()) {
                    if (solution == null || !solution.accepted(clz)) continue;
                    return solution;
                }
            }
        }
        catch (Throwable map) {
            // empty catch block
        }
        try {
            for (ConflictSolution solution : SOLUTION_CONCRETE_SPI_FACADE.getAllInstances()) {
                if (solution == null || !solution.accepted(clz)) continue;
                return solution;
            }
        }
        catch (Throwable map) {
            // empty catch block
        }
        try {
            Class<?> c = Class.forName(ConcreteHelper.getProfile().getString(ConflictSolution.class.getCanonicalName()));
            return (ConflictSolution)c.newInstance();
        }
        catch (Throwable throwable) {
            return DEFAULT_CONFLICT_SOLUTION;
        }
    }

    @Override
    public final <T> T getBean(Class<T> type) {
        Map<String, T> instanceMap = this.getBeansOfType(type);
        switch (instanceMap.size()) {
            case 0: {
                throw new ConcreteException(1011, type.getName());
            }
            case 1: {
                return instanceMap.values().iterator().next();
            }
        }
        return AbstractBeanProvider.getSolution(type).conflict(instanceMap, type);
    }
}

