/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Stack;
import org.coodex.concrete.api.Abstract;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.api.MicroService;
import org.coodex.concrete.common.Assert;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteToolkit;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.util.Profile;

public class ConcreteHelper {
    public static Profile getProfile() {
        return ConcreteToolkit.getProfile();
    }

    public static String getServicesName(Class<?> clz) {
        return ConcreteToolkit.getServiceName(clz);
    }

    public static String getMethodName(Method method) {
        return ConcreteToolkit.getMethodName((Method)method);
    }

    public static DefinitionContext getContextIfFound(Method method, Class<?> clz) {
        DefinitionContext context = ConcreteHelper.getContext(method, clz);
        Assert.is(context == null, 1001, method.getName(), clz.getCanonicalName());
        Assert.is(context.getDeclaringMethod() == null, 1002, ConcreteHelper.getServicesName(clz), method.getName());
        return context;
    }

    public static DefinitionContext getContext(Method method, Class<?> clz) {
        return ConcreteHelper.getContext(method, clz, new Stack());
    }

    private static DefinitionContext getContext(Method method, Class<?> clz, Stack<Class<?>> stack) {
        if (clz == null) {
            return null;
        }
        if (ConcreteService.class.equals(clz) || !ConcreteService.class.isAssignableFrom(clz)) {
            return null;
        }
        if (stack.contains(clz)) {
            return null;
        }
        stack.add(clz);
        if (clz.getAnnotation(MicroService.class) != null && clz.getAnnotation(Abstract.class) == null) {
            DefinitionContext context = new DefinitionContext();
            context.setDeclaringClass(clz);
            Method unitMethod = ConcreteHelper.findMethod(method, clz);
            if (unitMethod == null) {
                return null;
            }
            context.setDeclaringMethod(unitMethod);
            return context;
        }
        for (Class<?> clazz : clz.getInterfaces()) {
            DefinitionContext context = ConcreteHelper.getContext(method, clazz, stack);
            if (context == null) continue;
            return context;
        }
        return ConcreteHelper.getContext(method, clz.getSuperclass(), stack);
    }

    private static Method findMethod(Method method, Class<?> clz) {
        return ConcreteHelper.findMethod(method, clz, new Stack());
    }

    private static Method findMethod(Method method, Class<?> clz, Collection<Class<?>> stack) {
        if (stack.contains(clz)) {
            return null;
        }
        stack.add(clz);
        try {
            return clz.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            for (Class<?> clazz : clz.getInterfaces()) {
                Method m = ConcreteHelper.findMethod(method, clazz, stack);
                if (m == null) continue;
                return m;
            }
            return null;
        }
    }

    public static final ConcreteException findException(Throwable th) {
        if (th == null) {
            return null;
        }
        for (Throwable t = th; t != null; t = t.getCause()) {
            if (!(t instanceof ConcreteException)) continue;
            return (ConcreteException)t;
        }
        return null;
    }

    public static final ConcreteException getException(Throwable th) {
        ConcreteException concreteException = ConcreteHelper.findException(th);
        if (concreteException == null) {
            concreteException = new ConcreteException(99999, th.getLocalizedMessage());
            concreteException.initCause(th);
        }
        return concreteException;
    }
}

