/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DefinitionContext;

public class RuntimeContext
extends DefinitionContext {
    private Class<? extends ConcreteService> actualClass;
    private Method actualMethod;

    private RuntimeContext() {
    }

    public static final RuntimeContext getRuntimeContext(Method method, Class<?> clz) {
        DefinitionContext context = ConcreteHelper.getContext(method, clz);
        if (context == null) {
            return null;
        }
        RuntimeContext runtimeContext = new RuntimeContext();
        runtimeContext.setDeclaringMethod(context.getDeclaringMethod());
        runtimeContext.setDeclaringClass(context.getDeclaringClass());
        runtimeContext.setActualClass(clz);
        runtimeContext.setActualMethod(method);
        return runtimeContext;
    }

    public Class<? extends ConcreteService> getActualClass() {
        return this.actualClass;
    }

    public Method getActualMethod() {
        return this.actualMethod;
    }

    void setActualClass(Class<? extends ConcreteService> actualClass) {
        this.actualClass = actualClass;
    }

    void setActualMethod(Method actualMethod) {
        this.actualMethod = actualMethod;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        if (this.actualMethod == null) {
            return null;
        }
        for (Class<?> clz = this.actualMethod.getDeclaringClass(); clz != null; clz = clz.getSuperclass()) {
            try {
                Method method = clz.getMethod(this.actualMethod.getName(), this.actualMethod.getParameterTypes());
                T annotation = method.getAnnotation(annotationType);
                if (annotation != null) {
                    return annotation;
                }
                clz = method.getDeclaringClass();
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return this.getDeclaringMethod() == null ? null : (T)this.getDeclaringMethod().getAnnotation(annotationType);
    }
}

