/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common.conflictsolutions;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ConflictSolution;
import org.coodex.util.Common;
import org.coodex.util.Profile;

public class BeanNameFilter
implements ConflictSolution {
    private static final Profile profile = ConcreteHelper.getProfile();

    private Set<String> filter(Set<String> set) {
        String prefix = profile.getString(BeanNameFilter.class.getCanonicalName() + ".prefix");
        if (Common.isBlank((String)prefix)) {
            return set;
        }
        HashSet<String> stringSet = new HashSet<String>();
        for (String str : set) {
            if (str == null || !str.startsWith(prefix)) continue;
            stringSet.add(str);
        }
        return stringSet;
    }

    @Override
    public boolean accepted(Class<?> clazz) {
        return true;
    }

    @Override
    public <T> T conflict(Map<String, T> beans, Class<T> clz) {
        Set<String> set = this.filter(beans.keySet());
        switch (set.size()) {
            case 0: {
                throw new ConcreteException(1011, clz);
            }
            case 1: {
                return beans.get(set.iterator().next());
            }
        }
        throw new ConcreteException(1012, clz, set.size());
    }
}

