/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.core.intercept.ConcreteInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInterceptor
implements ConcreteInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractInterceptor.class);

    protected static final RuntimeContext getContext(MethodInvocation joinPoint) {
        return RuntimeContext.getRuntimeContext(joinPoint.getMethod(), joinPoint.getThis().getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        RuntimeContext context = AbstractInterceptor.getContext(invocation);
        if (context == null || !this.accept(context)) {
            return invocation.proceed();
        }
        this.before(context, invocation);
        try {
            Object result = this.around(context, invocation);
            try {
                this.after(context, invocation, result);
            }
            catch (Throwable t) {
                log.warn("Error occured in afterAdvice. {}", (Object)t.getLocalizedMessage(), (Object)t);
            }
            finally {
                return result;
            }
        }
        catch (ConcreteException ce) {
            throw ce;
        }
        catch (Throwable t) {
            Throwable t2 = this.onError(context, invocation, t);
            throw t2 == null ? t : t2;
        }
    }

    @Override
    public boolean accept(RuntimeContext context) {
        return true;
    }

    @Override
    public Object around(RuntimeContext context, MethodInvocation joinPoint) throws Throwable {
        return joinPoint.proceed();
    }

    @Override
    public void before(RuntimeContext context, MethodInvocation joinPoint) {
    }

    @Override
    public Object after(RuntimeContext context, MethodInvocation joinPoint, Object result) {
        return result;
    }

    @Override
    public Throwable onError(RuntimeContext context, MethodInvocation joinPoint, Throwable th) {
        return th;
    }
}

