/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.core.intercept.AbstractInterceptor;
import org.coodex.concrete.core.intercept.ConcreteInterceptor;

public class InterceptorChain
extends AbstractInterceptor
implements Set<ConcreteInterceptor> {
    private static Comparator<ConcreteInterceptor> comparator = new Comparator<ConcreteInterceptor>(){

        @Override
        public int compare(ConcreteInterceptor o1, ConcreteInterceptor o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getOrder() - o2.getOrder();
        }
    };
    private Set<ConcreteInterceptor> interceptors = new HashSet<ConcreteInterceptor>();

    @Override
    public int getOrder() {
        return -1;
    }

    public InterceptorChain() {
    }

    public InterceptorChain(List<ConcreteInterceptor> interceptors) {
        this.interceptors.addAll(interceptors);
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        return super.invoke(new MethodInvocationChain(this.createQueue(), invocation));
    }

    private Queue<ConcreteInterceptor> createQueue() {
        LinkedList<ConcreteInterceptor> queue = new LinkedList<ConcreteInterceptor>();
        ConcreteInterceptor[] interceptors = this.interceptors.toArray(new ConcreteInterceptor[0]);
        Arrays.sort(interceptors, comparator);
        for (ConcreteInterceptor interceptor : interceptors) {
            if (interceptor == null || interceptor instanceof InterceptorChain) continue;
            queue.add(interceptor);
        }
        return queue;
    }

    @Override
    public int size() {
        return this.interceptors.size();
    }

    @Override
    public boolean isEmpty() {
        return this.interceptors.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.interceptors.contains(o);
    }

    @Override
    public Iterator<ConcreteInterceptor> iterator() {
        return this.interceptors.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.interceptors.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.interceptors.toArray(a);
    }

    @Override
    public boolean add(ConcreteInterceptor concreteInterceptor) {
        return this.interceptors.add(concreteInterceptor);
    }

    @Override
    public boolean remove(Object o) {
        return this.interceptors.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.interceptors.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends ConcreteInterceptor> c) {
        return this.interceptors.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.interceptors.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.interceptors.removeAll(c);
    }

    @Override
    public void clear() {
        this.interceptors.clear();
    }

    private static class MethodInvocationChain
    implements MethodInvocation {
        private Queue<ConcreteInterceptor> queue;
        private MethodInvocation invocation;

        public MethodInvocationChain(Queue<ConcreteInterceptor> queue, MethodInvocation invocation) {
            this.queue = queue;
            this.invocation = invocation;
        }

        public Method getMethod() {
            return this.invocation.getMethod();
        }

        public Object[] getArguments() {
            return this.invocation.getArguments();
        }

        public Object proceed() throws Throwable {
            if (this.queue.isEmpty()) {
                return this.invocation.proceed();
            }
            ConcreteInterceptor interceptor = this.queue.poll();
            return interceptor.invoke(new MethodInvocationChain(this.queue, this.invocation));
        }

        public Object getThis() {
            return this.invocation.getThis();
        }

        public AccessibleObject getStaticPart() {
            return this.invocation.getStaticPart();
        }
    }
}

