/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept.atoms;

import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.executable.ExecutableValidator;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ConcreteSPIFacade;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.common.ViolationsFormatter;
import org.coodex.util.Profile;
import org.coodex.util.SPIFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BeanValidation {
    private static Profile concreteProfile = ConcreteHelper.getProfile();
    private static final Logger log = LoggerFactory.getLogger(BeanValidation.class);
    private static final ViolationsFormatter DEFAULT_FORMMATER = new ViolationsFormatter(){

        @Override
        public <T> String format(Collection<ConstraintViolation<T>> violations) {
            StringBuilder buf = new StringBuilder();
            for (ConstraintViolation<T> violation : violations) {
                buf.append(violation.getMessage()).append("\n");
            }
            return buf.toString();
        }
    };
    private static final SPIFacade<ViolationsFormatter> VIOLATIONS_FORMATTER_SPI = new ConcreteSPIFacade<ViolationsFormatter>(){

        protected ViolationsFormatter getDefaultProvider() {
            return DEFAULT_FORMMATER;
        }
    };
    private static ExecutableValidator executableValidator = null;
    private static boolean hasProvider = true;

    private static synchronized ExecutableValidator getValidator() {
        if (executableValidator == null && hasProvider) {
            try {
                executableValidator = Validation.buildDefaultValidatorFactory().getValidator().forExecutables();
            }
            catch (Throwable t) {
                hasProvider = false;
                log.warn("Failed to load validation provider: {}", (Object)t.getLocalizedMessage());
            }
        }
        return executableValidator;
    }

    public static boolean accept(RuntimeContext context) {
        return concreteProfile.getBool("aspect.bean.validation", true) && BeanValidation.getValidator() != null;
    }

    public static void before(RuntimeContext context, MethodInvocation joinPoint) {
        BeanValidation.checkViolations(BeanValidation.getValidator().validateParameters(joinPoint.getThis(), context.getDeclaringMethod(), joinPoint.getArguments(), new Class[0]));
    }

    public static void checkViolations(Set<ConstraintViolation<Object>> constraintViolations) {
        if (constraintViolations.size() > 0) {
            throw new ConcreteException(1009, ((ViolationsFormatter)VIOLATIONS_FORMATTER_SPI.getInstance()).format(constraintViolations));
        }
    }
}

