/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept.atoms;

import java.util.HashSet;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.api.AccessAllow;
import org.coodex.concrete.api.Domain;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.Assert;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.TokenWrapper;
import org.coodex.util.Common;
import org.coodex.util.Profile;

public abstract class RBAC {
    private static Token token = TokenWrapper.getInstance();

    public static void before(RuntimeContext context, MethodInvocation joinPoint) {
        if (context.getDeclaringMethod() != null) {
            AccessAllow accessAllow;
            Domain owner;
            Profile profile = Profile.getProfile((String)(context.getModuleName() + ".properties"));
            String[] acl = profile.getStrList(context.getMethodName());
            String domain = profile.getString("domain");
            if (domain == null && (owner = context.getDeclaringAnnotation(Domain.class)) != null && !Common.isBlank((String)owner.value().trim())) {
                domain = owner.value();
            }
            if (acl == null && (accessAllow = context.getDeclaringMethod().getAnnotation(AccessAllow.class)) != null && (acl = accessAllow.roles()).length == 0) {
                acl = new String[]{"EVERYBODY"};
            }
            RBAC.rbac(acl, domain);
        }
    }

    public static void rbac(String[] acl, String domain) {
        if (acl != null) {
            Account currentAccount = RBAC.getCurrentAccount();
            Assert.isNull(currentAccount, 1005, token);
            Assert.is(!currentAccount.isValid(), 1007, new Object[0]);
            Assert.is(!token.isAccountCredible(), 1008, new Object[0]);
            Set<String> accountDomainRoles = RBAC.getAccountDomainRoles(domain, currentAccount);
            if (accountDomainRoles.contains("*")) {
                return;
            }
            Set roles = Common.arrayToSet((Object[])acl);
            Assert.is(accountDomainRoles.size() == 0 || Common.intersection((Set)roles, accountDomainRoles).size() == 0, 1006, new Object[0]);
        }
    }

    private static Set<String> getAccountDomainRoles(String domain, Account currentAccount) {
        HashSet<String> accountDomainRoles = new HashSet<String>();
        Set accountRoles = currentAccount.getRoles();
        if (accountRoles != null) {
            if (Common.isBlank((String)domain)) {
                accountDomainRoles.addAll(accountRoles);
            } else {
                int domainPrefixLen = domain.length() + 1;
                for (String role : accountRoles) {
                    if (Common.isBlank((String)role)) continue;
                    if (role.equals("*")) {
                        accountDomainRoles.add("*");
                        break;
                    }
                    if (role.startsWith("*.") && role.length() > 2) {
                        accountDomainRoles.add(role.substring(2));
                        continue;
                    }
                    if (!role.startsWith(domain + ".") || role.length() <= domainPrefixLen) continue;
                    accountDomainRoles.add(role.substring(domainPrefixLen));
                }
            }
        }
        if (!Common.isBlank((String)domain)) {
            if (accountDomainRoles.size() > 0) {
                accountDomainRoles.add("EVERYBODY");
            }
        } else {
            accountDomainRoles.add("EVERYBODY");
        }
        return accountDomainRoles;
    }

    private static Account getCurrentAccount() {
        return token.currentAccount();
    }
}

