/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept.timecheckers;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import org.coodex.concrete.api.ServiceTimingChecker;
import org.coodex.util.Common;

public class ByWorkDay
implements ServiceTimingChecker {
    private static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private String weekday = "1,2,3,4,5";
    private String restDay = null;
    private String workday = null;

    private boolean inWorkday(String now) {
        return this.inList(now, this.workday);
    }

    private boolean inList(String now, String dayList) {
        if (Common.isBlank((String)dayList)) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(dayList, ",");
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            if (Common.isBlank((String)s) || !s.trim().equals(now)) continue;
            return true;
        }
        return false;
    }

    private boolean inRestDay(String now) {
        return this.inList(now, this.restDay);
    }

    private boolean isWeekday() {
        if (Common.isBlank((String)this.weekday)) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(this.weekday, ",");
        boolean[] weekday = new boolean[]{false, false, false, false, false, false, false};
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            if (Common.isBlank((String)s)) continue;
            try {
                int num = Integer.parseInt(s.trim());
                if (num >= 7 || num < 0) continue;
                weekday[num] = true;
            }
            catch (Throwable throwable) {}
        }
        Calendar c = Calendar.getInstance();
        return weekday[c.get(7) - 1];
    }

    public boolean isAllowed() {
        String now = format.format(new Date());
        if (this.inWorkday(now)) {
            return true;
        }
        if (this.inRestDay(now)) {
            return false;
        }
        return this.isWeekday();
    }
}

