/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.token;

import java.io.Serializable;
import java.util.Enumeration;
import org.coodex.closure.Closure;
import org.coodex.closure.threadlocals.StackClosureThreadLocal;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.Assert;
import org.coodex.concrete.common.ConcreteClosure;
import org.coodex.concrete.common.Token;

public class TokenWrapper
implements Token {
    private static final StackClosureThreadLocal<Token> closure = new StackClosureThreadLocal();
    private static final Token singletonInstance = new TokenWrapper();

    private Token getToken() {
        return this.getToken(true);
    }

    private Token getToken(boolean checkValidation) {
        Token token = (Token)closure.get();
        Assert.isNull(token, 1003, new Object[0]);
        Assert.is(checkValidation && !token.isValid(), 1004, token.getTokenId());
        return token;
    }

    public static final Token getInstance() {
        return singletonInstance;
    }

    public static final Object closure(Token token, ConcreteClosure runnable) {
        return closure.runWith((Object)token, (Closure)runnable);
    }

    public long created() {
        return this.getToken().created();
    }

    public boolean isValid() {
        return this.getToken(false).isValid();
    }

    public void invalidate() {
        this.getToken().invalidate();
    }

    public void onInvalidate() {
        this.getToken().onInvalidate();
    }

    public <ID extends Serializable> Account<ID> currentAccount() {
        return this.getToken().currentAccount();
    }

    public void setAccount(Account account) {
        this.getToken().setAccount(account);
    }

    public boolean isAccountCredible() {
        return this.getToken().isAccountCredible();
    }

    public void setAccountCredible(boolean credible) {
        this.getToken().setAccountCredible(credible);
    }

    public String getTokenId() {
        return this.getToken(false).getTokenId();
    }

    public <T> T getAttribute(String key) {
        return (T)this.getToken().getAttribute(key);
    }

    public void setAttribute(String key, Serializable attribute) {
        this.getToken().setAttribute(key, attribute);
    }

    public void removeAttribute(String key) {
        this.getToken().removeAttribute(key);
    }

    public Enumeration<String> attributeNames() {
        return this.getToken().attributeNames();
    }

    public void flush() {
        this.getToken().flush();
    }
}

