/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.token.local;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.AccountFactory;
import org.coodex.concrete.common.BeanProviderFacade;
import org.coodex.concrete.common.Token;
import org.coodex.util.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalToken
implements Token {
    private static final Logger log = LoggerFactory.getLogger(LocalToken.class);
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Serializable currentAccountId = null;
    private boolean accountCredible = false;
    private boolean valid = true;
    private long lastActive;
    private String sessionId = Common.getUUIDStr();
    private Runnable onInvalid;
    private long created = System.currentTimeMillis();

    public LocalToken(String sessionId, Runnable onInvalid) {
        if (sessionId != null) {
            this.sessionId = sessionId;
        }
        this.lastActive = System.currentTimeMillis();
        this.onInvalid = onInvalid;
    }

    void active() {
        this.lastActive = System.currentTimeMillis();
    }

    public long getLastActive() {
        return this.lastActive;
    }

    public long created() {
        return this.created;
    }

    public boolean isValid() {
        return this.valid;
    }

    void _invalidate() {
        this.attributes.clear();
        this.currentAccountId = null;
        this.accountCredible = false;
        this.valid = false;
    }

    public void invalidate() {
        this._invalidate();
        this.onInvalidate();
    }

    public void onInvalidate() {
        if (this.onInvalid != null) {
            try {
                this.onInvalid.run();
            }
            catch (Throwable t) {
                log.warn("error occurred on LocalToken invalidate. {}: {}", (Object)t.getClass().getCanonicalName(), (Object)t.getLocalizedMessage());
            }
        }
    }

    public <ID extends Serializable> Account<ID> currentAccount() {
        return this.currentAccountId == null ? null : BeanProviderFacade.getBeanProvider().getBean(AccountFactory.class).getAccountByID(this.currentAccountId);
    }

    public void setAccount(Account account) {
        this.currentAccountId = account.getId();
    }

    public boolean isAccountCredible() {
        return this.currentAccountId == null ? false : this.accountCredible;
    }

    public void setAccountCredible(boolean credible) {
        this.accountCredible = credible;
    }

    public String getTokenId() {
        return this.sessionId;
    }

    public <T> T getAttribute(String key) {
        return (T)this.attributes.get(key);
    }

    public void setAttribute(String key, Serializable attribute) {
        this.attributes.put(key, attribute);
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public Enumeration<String> attributeNames() {
        return new Vector<String>(this.attributes.keySet()).elements();
    }

    public void flush() {
    }

    public String toString() {
        return "LocalToken{attributes=" + this.attributes + ", currentAccountId=" + this.currentAccountId + ", accountCredible=" + this.accountCredible + ", valid=" + this.valid + ", lastActive=" + this.lastActive + ", sessionId='" + this.sessionId + '\'' + ", onInvalid=" + this.onInvalid + ", created=" + this.created + '}';
    }
}

