/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.token.sharedcache;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.AccountFactory;
import org.coodex.concrete.common.BeanProviderFacade;
import org.coodex.concrete.common.Token;
import org.coodex.sharedcache.SharedCacheClient;

public class SharedCacheToken
implements Token {
    private static final String PREFIX = SharedCacheToken.class.getCanonicalName();
    private Data tokenData;
    private SharedCacheClient client;
    private String tokenId;
    private long maxIdleTime;
    private String cacheKey;

    SharedCacheToken(SharedCacheClient client, String tokenId, long maxIdleTime) {
        this.client = client;
        this.tokenId = tokenId;
        this.maxIdleTime = maxIdleTime;
        this.cacheKey = PREFIX + "." + this.tokenId;
        this.init();
    }

    private void write() {
        this.client.put(this.cacheKey, (Serializable)this.tokenData, this.maxIdleTime);
    }

    private synchronized void init() {
        if (this.tokenData == null) {
            this.tokenData = (Data)this.client.get(this.cacheKey);
            if (this.tokenData == null) {
                this.tokenData = new Data();
            }
        }
        this.write();
    }

    public long created() {
        return this.tokenData.created;
    }

    public boolean isValid() {
        return this.tokenData.valid;
    }

    public void invalidate() {
        this.tokenData.valid = false;
        this.tokenData.map.clear();
        this.client.remove(this.cacheKey);
    }

    public void onInvalidate() {
    }

    public <ID extends Serializable> Account<ID> currentAccount() {
        return this.tokenData.currentAccountId == null ? null : BeanProviderFacade.getBeanProvider().getBean(AccountFactory.class).getAccountByID(this.tokenData.currentAccountId);
    }

    private boolean sameAccount(Account account) {
        if (this.tokenData.currentAccountId == null && account == null) {
            return true;
        }
        if (this.tokenData.currentAccountId == null || account == null) {
            return false;
        }
        return this.tokenData.currentAccountId.equals(account.getId());
    }

    public void setAccount(Account account) {
        if (!this.sameAccount(account)) {
            this.tokenData.currentAccountId = account == null ? null : account.getId();
            this.write();
        }
    }

    public boolean isAccountCredible() {
        return this.tokenData.currentAccountId == null ? false : this.tokenData.accountCredible;
    }

    public void setAccountCredible(boolean credible) {
        if (this.tokenData.accountCredible != credible) {
            this.tokenData.accountCredible = credible;
            this.write();
        }
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public <T> T getAttribute(String key) {
        return (T)this.tokenData.map.get(key);
    }

    public void setAttribute(String key, Serializable attribute) {
        if (this.isValid()) {
            this.tokenData.map.put(key, attribute);
            this.write();
        }
    }

    public void removeAttribute(String key) {
        if (this.isValid()) {
            this.tokenData.map.remove(key);
            this.write();
        }
    }

    public Enumeration<String> attributeNames() {
        return new Vector<String>(this.tokenData.map.keySet()).elements();
    }

    public void flush() {
        this.write();
    }

    public String toString() {
        return "SharedCacheToken{tokenData=" + this.tokenData + ", client=" + this.client + ", tokenId='" + this.tokenId + '\'' + ", maxIdleTime=" + this.maxIdleTime + ", cacheKey='" + this.cacheKey + '\'' + '}';
    }

    static class Data
    implements Serializable {
        long created = System.currentTimeMillis();
        boolean valid = true;
        Serializable currentAccountId = null;
        boolean accountCredible = false;
        HashMap<String, Serializable> map = new HashMap();

        Data() {
        }

        public String toString() {
            return "Data{created=" + this.created + ", valid=" + this.valid + ", currentAccountId=" + this.currentAccountId + ", accountCredible=" + this.accountCredible + ", map=" + this.map + '}';
        }
    }
}

