/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client;

import java.util.HashMap;
import java.util.Map;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.util.Common;

public class ClientCommon {
    private static final Map<String, String> CLIENT_TOKEN_MANAGER = new HashMap<String, String>();

    private static String getKey(String domain) {
        return Common.isBlank((String)domain) ? "" : "." + domain;
    }

    public static Domain getDomain(String domain) {
        return new Domain(ClientCommon.getDomainIdentify(domain), ClientCommon.getDomainType(domain), ClientCommon.getDomainAsyncSupport(domain));
    }

    private static boolean getDomainAsyncSupport(String domain) {
        return ConcreteHelper.getProfile().getBool("concrete.client" + ClientCommon.getKey(domain) + ".async", true);
    }

    private static String getDomainType(String domain) {
        return ConcreteHelper.getProfile().getString("concrete.client" + ClientCommon.getKey(domain) + ".type");
    }

    private static String getDomainIdentify(String domain) {
        int len;
        String s = ConcreteHelper.getProfile().getString("concrete.client" + ClientCommon.getKey(domain) + ".domain", Common.nullToStr((String)domain)).trim();
        char[] buf = s.toCharArray();
        for (len = buf.length; len > 0 && buf[len - 1] == '/'; --len) {
        }
        s = new String(buf, 0, len);
        return s;
    }

    public static void setTokenId(String key, String tokenId) {
        if (!Common.isBlank((String)key)) {
            CLIENT_TOKEN_MANAGER.put(key, tokenId);
        }
    }

    public static String getTokenId(String key) {
        return Common.isBlank((String)key) ? null : CLIENT_TOKEN_MANAGER.get(key);
    }

    public static class Domain {
        private String identify;
        private String type;
        private boolean asyncSupport;

        public Domain(String location, String type, boolean asyncSupport) {
            this.identify = location;
            this.type = type;
            this.asyncSupport = asyncSupport;
        }

        public boolean isAsyncSupport() {
            return this.asyncSupport;
        }

        public String getIdentify() {
            return this.identify;
        }

        public String getType() {
            return this.type;
        }
    }
}

