/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.coodex.concrete.client.MessageListener;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.util.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSubscriber {
    private static final Logger log = LoggerFactory.getLogger(MessageSubscriber.class);
    private static final Map<String, MessageListener<?>> listeners = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void subscribe(String subject, MessageListener<T> listener) {
        Map<String, MessageListener<?>> map = listeners;
        synchronized (map) {
            listeners.put(subject, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancel(String subject) {
        Map<String, MessageListener<?>> map = listeners;
        synchronized (map) {
            listeners.remove(subject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void next(String subject, String jsonMessage) {
        Map<String, MessageListener<?>> map = listeners;
        synchronized (map) {
            MessageListener<?> listener = listeners.get(subject);
            if (listener == null) {
                log.warn("No message listener found for: {}", (Object)subject);
                return;
            }
            try {
                listener.onMessage(JSONSerializerFactory.getInstance().parse(jsonMessage, TypeHelper.toTypeReference(MessageListener.class.getTypeParameters()[0], (Type[])new Type[]{listener.getClass()})));
            }
            catch (Throwable throwable) {
                log.error(throwable.getLocalizedMessage(), throwable);
            }
        }
    }
}

