/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.util.Map;
import org.coodex.concrete.common.ConcreteServiceLoader;
import org.coodex.concrete.common.LogFormatter;
import org.coodex.concrete.common.MessageFormatter;
import org.coodex.concrete.common.MessagePatternLoader;
import org.coodex.concrete.core.JavaTextFormatMessageFormatter;
import org.coodex.concrete.core.ResourceBundlesMessagePatternLoader;
import org.coodex.util.ServiceLoader;

public class AbstractMessageFacade {
    private static final MessageFormatter DEFAULT_MESSAGE_FORMATTER = new JavaTextFormatMessageFormatter();
    private static final MessagePatternLoader DEFAULT_PATTERN_LOADER = new ResourceBundlesMessagePatternLoader();
    private static final LogFormatter DEFAULT_LOG_FORMATTER = new LogFormatter(){

        public String format(String pattern, Map<String, Object> values) {
            return values == null ? null : values.toString();
        }
    };
    private static final ServiceLoader<MessageFormatter> MESSAGE_FORMATTER_SERVICE_LOADER = new ConcreteServiceLoader<MessageFormatter>(){

        @Override
        public MessageFormatter getConcreteDefaultProvider() {
            return DEFAULT_MESSAGE_FORMATTER;
        }
    };
    private static final ServiceLoader<MessagePatternLoader> MESSAGE_PATTERN_LOADER_SERVICE_LOADER = new ConcreteServiceLoader<MessagePatternLoader>(){

        @Override
        public MessagePatternLoader getConcreteDefaultProvider() {
            return DEFAULT_PATTERN_LOADER;
        }
    };
    private static final ServiceLoader<LogFormatter> LOG_FORMATTER_SERVICE_LOADER = new ConcreteServiceLoader<LogFormatter>(){

        @Override
        public LogFormatter getConcreteDefaultProvider() {
            return DEFAULT_LOG_FORMATTER;
        }
    };

    public static MessageFormatter getFormatter(Class<? extends MessageFormatter> formatterClass) {
        MessageFormatter formatter = formatterClass == null || formatterClass == MessageFormatter.class ? (MessageFormatter)MESSAGE_FORMATTER_SERVICE_LOADER.getInstance() : (MessageFormatter)MESSAGE_FORMATTER_SERVICE_LOADER.getInstance(formatterClass);
        return formatter == null ? DEFAULT_MESSAGE_FORMATTER : formatter;
    }

    public static MessagePatternLoader getPatternLoader(Class<? extends MessagePatternLoader> loaderClass) {
        MessagePatternLoader patternLoader = loaderClass == null || loaderClass == MessagePatternLoader.class ? (MessagePatternLoader)MESSAGE_PATTERN_LOADER_SERVICE_LOADER.getInstance() : (MessagePatternLoader)MESSAGE_PATTERN_LOADER_SERVICE_LOADER.getInstance(loaderClass);
        return patternLoader == null ? DEFAULT_PATTERN_LOADER : patternLoader;
    }

    public static LogFormatter getLogFormatter(Class<? extends LogFormatter> formatterClass) {
        return formatterClass == null || formatterClass == LogFormatter.class ? (LogFormatter)LOG_FORMATTER_SERVICE_LOADER.getInstance() : (LogFormatter)LOG_FORMATTER_SERVICE_LOADER.getInstance(formatterClass);
    }
}

