/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteHelper;

public final class Assert {
    public static final void is(boolean exp, int code, Object ... objects) {
        Assert.is(exp, new ConcreteException(code, objects));
    }

    public static final void is(boolean exp, ConcreteException ex) {
        if (exp) {
            throw ex;
        }
    }

    public static final void is(boolean exp, String message) {
        Assert.is(exp, ConcreteHelper.getException(new RuntimeException(message)));
    }

    public static final void not(boolean exp, int code, Object ... objects) {
        Assert.not(exp, new ConcreteException(code, objects));
    }

    public static final void not(boolean exp, ConcreteException ex) {
        Assert.is(!exp, ex);
    }

    public static final void not(boolean exp, String message) {
        Assert.is(!exp, message);
    }

    public static final <T> T isNull(T o, int code, Object ... objects) {
        return Assert.isNull(o, new ConcreteException(code, objects));
    }

    public static final <T> T isNull(T o, ConcreteException exp) {
        Assert.is(o == null, exp);
        return o;
    }

    public static final <T> T isNull(T o, String message) {
        return Assert.isNull(o, ConcreteHelper.getException(new RuntimeException(message)));
    }

    public static final void notNull(Object o, int code, Object ... objects) {
        Assert.notNull(o, new ConcreteException(code, objects));
    }

    public static final void notNull(Object o, ConcreteException ex) {
        Assert.is(o != null, ex);
    }

    public static final void notNull(Object o, String message) {
        Assert.notNull(o, ConcreteHelper.getException(new RuntimeException(message)));
    }
}

