/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concurrent.ExecutorsHelper;
import org.coodex.util.Common;
import org.coodex.util.RecursivelyProfile;

public abstract class ConcreteCache<K, V> {
    private static final ScheduledExecutorService THREADS = ExecutorsHelper.newScheduledThreadPool((int)ConcreteHelper.getProfile().getInt("cache.thread.pool.size", 1));
    private static final RecursivelyProfile RECURSIVELY_PROFILE = new RecursivelyProfile(ConcreteHelper.getProfile());
    private Map<K, Cached<V>> cache = new HashMap<K, Cached<V>>();
    private TimeUnit unit;

    public ConcreteCache() {
        this(TimeUnit.MINUTES);
    }

    protected String getRule() {
        return null;
    }

    protected final long getCachingTime() {
        return Common.toLong((String)RECURSIVELY_PROFILE.getString(this.getRule(), "cache.object.life"), (long)10L);
    }

    public ConcreteCache(TimeUnit unit) {
        this.unit = unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(final K key) {
        long time = this.getCachingTime();
        if (time <= 0L) {
            return this.load(key);
        }
        Map<K, Cached<V>> map = this.cache;
        synchronized (map) {
            if (!this.cache.containsKey(key)) {
                this.cache.put(key, new Cached<V>(this.load(key), THREADS.schedule(new Runnable(){

                    @Override
                    public void run() {
                        ConcreteCache.this.cache.remove(key);
                    }
                }, time, this.unit)));
            }
        }
        Cached<V> cached = this.cache.get(key);
        return cached == null ? null : (V)cached.value;
    }

    public void invalidate(K key) {
        Cached<V> cached = this.cache.remove(key);
        if (cached != null) {
            cached.future.cancel(false);
        }
    }

    protected abstract V load(K var1);

    static class Cached<V> {
        V value;
        ScheduledFuture future;

        public Cached(V value, ScheduledFuture future) {
            this.value = value;
            this.future = future;
        }
    }
}

