/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.util.Locale;
import java.util.Map;
import org.coodex.closure.Closure;
import org.coodex.closure.ClosureContext;
import org.coodex.closure.StackClosureContext;
import org.coodex.concrete.common.ConcreteClosure;
import org.coodex.concrete.common.ServiceContext;

public final class ConcreteContext {
    public static final int SIDE_SERVER = 0;
    public static final int SIDE_LOCAL_INVOKE = 1;
    public static final int SIDE_TEST = 2;
    public static final int SIDE_CLIENT = 3;
    private static final ClosureContext<ServiceContext> CONTEXT = new StackClosureContext();

    public static final ServiceContext getServiceContext() {
        return (ServiceContext)CONTEXT.get();
    }

    public static final void putLoggingData(String key, Object value) {
        ConcreteContext.getLogging().put(key, value);
    }

    public static final Map<String, Object> getLoggingData() {
        return ConcreteContext.getLogging();
    }

    private static final Map<String, Object> getLogging() {
        return ((ServiceContext)CONTEXT.get()).getLogging();
    }

    public static final Object runWithContext(final ServiceContext context, final ConcreteClosure runnable) {
        return new ConcreteClosure(){

            @Override
            public Object concreteRun() throws Throwable {
                return CONTEXT.run((Object)context, (Closure)runnable);
            }
        }.run();
    }

    private static Locale getLocale() {
        return ((ServiceContext)CONTEXT.get()).getSubjoin() == null ? Locale.getDefault() : ((ServiceContext)CONTEXT.get()).getSubjoin().getLocale();
    }
}

