/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.coodex.concrete.common.AbstractJsonSerializer;
import org.coodex.concrete.common.JSONSerializerFactory;

public class FastJsonSerializer
extends AbstractJsonSerializer {
    private Class jsonClass = null;
    private Method toJSONString = null;
    private Method parseObject = null;
    private Class feature = null;
    private Object ignoreNotMatch = null;

    private synchronized void init() throws ClassNotFoundException, NoSuchMethodException {
        if (this.jsonClass == null) {
            this.jsonClass = Class.forName("com.alibaba.fastjson.JSON");
            this.feature = Class.forName("com.alibaba.fastjson.parser.Feature");
            for (Object e : this.feature.getEnumConstants()) {
                if (!"IgnoreNotMatch".equals(e.toString())) continue;
                this.ignoreNotMatch = e;
                break;
            }
            this.toJSONString = this.jsonClass.getMethod("toJSONString", Object.class);
            this.parseObject = this.jsonClass.getMethod("parseObject", String.class, Type.class, Array.newInstance(this.feature, 0).getClass());
        }
    }

    private Object $parse(String json, Type t) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        this.init();
        Object array = Array.newInstance(this.feature, 1);
        Array.set(array, 0, this.ignoreNotMatch);
        return this.parseObject.invoke(null, json, t, array);
    }

    private String $toJson(Object t) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, ClassNotFoundException {
        this.init();
        return (String)this.toJSONString.invoke(null, t);
    }

    @Override
    public <T> T parse(String json, Type t) {
        try {
            return (T)(String.class.equals((Object)t) ? json : this.$parse(json, t));
        }
        catch (Throwable th) {
            throw th instanceof RuntimeException ? (RuntimeException)th : new RuntimeException(th);
        }
    }

    @Override
    public String toJson(Object t) {
        try {
            return this.$toJson(t);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        System.out.println(JSONSerializerFactory.getInstance().toJson("ok"));
        System.out.println(JSONSerializerFactory.getInstance().parse("ok", (Type)((Object)String.class)));
    }
}

