/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.api.Overlay;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.DefinitionContextImpl;

public class RuntimeContext
extends DefinitionContextImpl {
    private Class<? extends ConcreteService> actualClass;
    private Method actualMethod;

    private RuntimeContext() {
    }

    public static final RuntimeContext getRuntimeContext(Method method, Class<?> clz) {
        DefinitionContext context = ConcreteHelper.getContext(method, clz);
        if (context == null) {
            return null;
        }
        RuntimeContext runtimeContext = new RuntimeContext();
        runtimeContext.setDeclaringMethod(context.getDeclaringMethod());
        runtimeContext.setDeclaringClass(context.getDeclaringClass());
        runtimeContext.setActualClass(clz);
        runtimeContext.setActualMethod(method);
        return runtimeContext;
    }

    public Class<? extends ConcreteService> getActualClass() {
        return this.actualClass;
    }

    public Method getActualMethod() {
        return this.actualMethod;
    }

    void setActualClass(Class<? extends ConcreteService> actualClass) {
        this.actualClass = actualClass;
    }

    void setActualMethod(Method actualMethod) {
        this.actualMethod = actualMethod;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Overlay overlayAnnotation = annotationClass.getAnnotation(Overlay.class);
        boolean justDefinition = overlayAnnotation == null ? true : overlayAnnotation.definition();
        T annotation = justDefinition ? this.getDeclaringMethod().getAnnotation(annotationClass) : this.getAnnotationFrom(annotationClass, this.actualMethod, this.getDeclaringMethod(), this.actualClass);
        return annotation == null ? super.getAnnotation(annotationClass) : annotation;
    }

    private <T extends Annotation> T getAnnotationFromImpl(Class<T> annotationClass) {
        T annotation = this.actualMethod.getAnnotation(annotationClass);
        return annotation == null ? this.actualClass.getAnnotation(annotationClass) : annotation;
    }
}

