/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.Subjoin;
import org.coodex.util.Common;

public class SubjoinWrapper
implements Subjoin {
    private static Subjoin instance = new SubjoinWrapper();

    public static Subjoin getInstance() {
        return instance;
    }

    private Subjoin getSubjoin() {
        Subjoin subjoin = ConcreteContext.getServiceContext().getSubjoin();
        return subjoin == null ? new DefaultSubjoin() : subjoin;
    }

    public Locale getLocale() {
        return this.getSubjoin().getLocale();
    }

    public String get(String name) {
        return this.getSubjoin().get(name);
    }

    public String get(String name, String split) {
        return this.getSubjoin().get(name, split);
    }

    public List<String> getList(String name) {
        return this.getSubjoin().getList(name);
    }

    public Set<String> keySet() {
        return this.getSubjoin().keySet();
    }

    public void set(String name, List<String> values) {
        this.getSubjoin().set(name, values);
    }

    public void add(String name, String value) {
        this.getSubjoin().add(name, value);
    }

    public static class DefaultSubjoin
    implements Subjoin {
        private Map<String, List<String>> subjoin = new HashMap<String, List<String>>();

        public Locale getLocale() {
            return Locale.getDefault();
        }

        public String get(String name) {
            return this.get(name, "; ");
        }

        public String get(String name, String split) {
            return Common.concat(this.subjoin.get(name), (String)split);
        }

        public List<String> getList(String name) {
            return this.subjoin.get(name);
        }

        public Set<String> keySet() {
            return this.subjoin.keySet();
        }

        public void set(String name, List<String> values) {
            this.subjoin.put(name, values);
        }

        public void add(String name, String value) {
            List<String> list = this.getList(name);
            if (list == null) {
                list = new ArrayList<String>();
                this.subjoin.put(name, list);
            }
            list.add(value);
        }
    }
}

