/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.codec.binary.Base64;
import org.coodex.concrete.api.Signable;
import org.coodex.concrete.api.pojo.Signature;
import org.coodex.concrete.common.Assert;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.IronPen;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.common.SignatureSerializer;
import org.coodex.concrete.common.struct.AbstractParam;
import org.coodex.concrete.common.struct.AbstractUnit;
import org.coodex.concrete.core.intercept.AbstractInterceptor;
import org.coodex.concrete.core.signature.SignUtil;
import org.coodex.util.Common;
import org.coodex.util.ReflectHelper;
import org.coodex.util.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSignatureInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractSignatureInterceptor.class);
    protected final String KEY_FIELD_ALGORITHM = "algorithm";
    protected final String KEY_FIELD_SIGN = "sign";
    protected final String KEY_FIELD_KEY_ID = "keyId";
    protected final String KEY_FIELD_NOISE = "noise";

    @Override
    public int getOrder() {
        return 900;
    }

    @Override
    public boolean accept(RuntimeContext context) {
        return context.getAnnotation(Signable.class) != null && ConcreteContext.getServiceContext().getCurrentUnit() != null;
    }

    private int getModel() {
        return ConcreteContext.getServiceContext().getSide() == null ? 0 : ConcreteContext.getServiceContext().getSide();
    }

    @Override
    public void before(RuntimeContext context, MethodInvocation joinPoint) {
        SignUtil.HowToSign howToSign = SignUtil.howToSign(context);
        switch (this.getModel()) {
            case 0: {
                this.serverSide_Verify(context, joinPoint, howToSign);
                return;
            }
            case 3: {
                this.clientSide_Sign(context, joinPoint, howToSign);
                return;
            }
        }
    }

    @Override
    public Object after(RuntimeContext context, MethodInvocation joinPoint, Object result) {
        SignUtil.HowToSign howToSign = SignUtil.howToSign(context);
        switch (this.getModel()) {
            case 0: {
                return this.serverSide_Sign(context, joinPoint, howToSign, result);
            }
            case 3: {
                return this.clientSide_Verify(context, joinPoint, howToSign, result);
            }
        }
        return result;
    }

    protected Map<String, Object> buildContent(AbstractUnit unit, Object[] args) {
        Class c;
        AbstractParam[] params = unit.getParameters();
        if (params == null) {
            return new HashMap<String, Object>();
        }
        if (!(params.length != 1 || Collection.class.isAssignableFrom(c = params[0].getType()) || c.isArray() || TypeHelper.isPrimitive((Class)c))) {
            try {
                return this.beanToMap(args[0]);
            }
            catch (Throwable th) {
                throw ConcreteHelper.getException(th);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (AbstractParam param : unit.getParameters()) {
            result.put(param.getName(), args[param.getIndex()]);
        }
        return result;
    }

    private String getPropertyName(String propertyName) {
        return SignUtil.PROFILE.getString("property." + propertyName, propertyName);
    }

    private void serverSide_Verify(RuntimeContext context, MethodInvocation joinPoint, SignUtil.HowToSign howToSign) {
        Map<String, Object> content = this.buildContent(ConcreteContext.getServiceContext().getCurrentUnit(), joinPoint.getArguments());
        Assert.isNull(this.getKeyField(content, "noise", null), 1016, "noise MUST NOT null.");
        String algorithm = this.getKeyField(content, "algorithm", howToSign.getAlgorithm());
        String keyId = this.getKeyField(content, "keyId", null);
        IronPen ironPen = howToSign.getIronPenFactory(algorithm).getIronPen(howToSign.getPaperName());
        SignatureSerializer serializer = howToSign.getSerializer();
        Assert.not(ironPen.verify(serializer.serialize(content), Base64.decodeBase64((String)this.getSignature(content)), algorithm, keyId), 1016, "server side verify failed.");
    }

    private Object serverSide_Sign(RuntimeContext context, MethodInvocation joinPoint, SignUtil.HowToSign howToSign, Object o) {
        try {
            if (o != null && o instanceof Signature) {
                Map<String, Object> content = this.buildContent(ConcreteContext.getServiceContext().getCurrentUnit(), joinPoint.getArguments());
                String algorithm = this.getKeyField(content, "algorithm", howToSign.getAlgorithm());
                String keyId = this.getKeyField(content, "keyId", null);
                IronPen ironPen = howToSign.getIronPenFactory(algorithm).getIronPen(howToSign.getPaperName());
                SignatureSerializer serializer = howToSign.getSerializer();
                return this.serverSign((Signature)o, algorithm, keyId, ironPen, serializer);
            }
            return o;
        }
        catch (Throwable th) {
            throw ConcreteHelper.getException(th);
        }
    }

    private Object serverSign(Signature signature, String algorithm, String keyId, IronPen ironPen, SignatureSerializer serializer) throws IllegalAccessException {
        signature.setNoise(Common.random((int)Integer.MAX_VALUE));
        signature.setSign(Base64.encodeBase64String((byte[])ironPen.sign(serializer.serialize(this.signatureToMap(signature)), algorithm, keyId)));
        return signature;
    }

    private Map<String, Object> signatureToMap(Signature signature) throws IllegalAccessException {
        if (signature == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Field field : ReflectHelper.getAllDeclaredFields(signature.getClass())) {
            if (field.getDeclaringClass().equals(Signature.class) && !"noise".equals(field.getName())) continue;
            field.setAccessible(true);
            result.put(field.getName(), field.get(signature));
        }
        return result;
    }

    private String getKeyField(Map<String, Object> content, String keyName, String defaultValue) {
        Object key;
        String propertyName = this.getPropertyName(keyName);
        Object object = key = content.containsKey(propertyName) ? content.get(propertyName) : ConcreteContext.getServiceContext().getSubjoin().get(propertyName);
        if (key != null) {
            content.put(propertyName, key);
        }
        return key == null ? defaultValue : key.toString();
    }

    private String getSignature(Map<String, Object> content) {
        String propertySign = this.getPropertyName("sign");
        String signStr = (String)content.remove(propertySign);
        if (signStr == null) {
            signStr = Assert.isNull(ConcreteContext.getServiceContext().getSubjoin().get(propertySign), 1016, "no signature found");
        }
        return signStr;
    }

    private String putKeyField(Map<String, Object> content, String keyName, Object value, RuntimeContext context, MethodInvocation joinPoint) {
        String propertyName = this.getPropertyName(keyName);
        if (content.containsKey(propertyName)) {
            if (content != null) {
                this.setArgument(context, joinPoint, propertyName, value);
            }
        } else if (value != null) {
            ConcreteContext.getServiceContext().getSubjoin().set(propertyName, Arrays.asList(value.toString()));
        }
        content.put(propertyName, value);
        return value == null ? null : value.toString();
    }

    private void clientSide_Sign(RuntimeContext context, MethodInvocation joinPoint, SignUtil.HowToSign howToSign) {
        Map<String, Object> content = this.buildContent(ConcreteContext.getServiceContext().getCurrentUnit(), joinPoint.getArguments());
        int noise = Common.random((int)0, (int)Integer.MAX_VALUE);
        this.putKeyField(content, "noise", noise, context, joinPoint);
        String algorithm = this.putKeyField(content, "algorithm", SignUtil.getString("algorithm", howToSign.getPaperName(), null), context, joinPoint);
        if (algorithm == null) {
            algorithm = howToSign.getAlgorithm();
        }
        String keyId = this.putKeyField(content, "keyId", SignUtil.getString("keyId", howToSign.getPaperName(), null), context, joinPoint);
        byte[] data = howToSign.getSerializer().serialize(content);
        String sign = Base64.encodeBase64String((byte[])howToSign.getIronPenFactory(algorithm).getIronPen(howToSign.getPaperName()).sign(data, algorithm, keyId));
        this.putKeyField(content, "sign", sign, context, joinPoint);
        log.debug("signature for[ {} ]: \n\t{}: {}\n\t{}: {}\n\t{}: {}\n\t{}: {}\n\t{}: {}", new Object[]{context.getActualMethod().getName(), this.getPropertyName("noise"), noise, this.getPropertyName("algorithm"), algorithm, this.getPropertyName("keyId"), keyId, this.getPropertyName("sign"), sign, "toSign", this.dataToString(data)});
    }

    private Object clientSide_Verify(RuntimeContext context, MethodInvocation joinPoint, SignUtil.HowToSign howToSign, Object o) {
        try {
            if (o != null && o instanceof Signature) {
                Map<String, Object> content = this.buildContent(ConcreteContext.getServiceContext().getCurrentUnit(), joinPoint.getArguments());
                String algorithm = this.putKeyField(content, "algorithm", SignUtil.getString("algorithm", howToSign.getPaperName(), null), context, joinPoint);
                if (algorithm == null) {
                    algorithm = howToSign.getAlgorithm();
                }
                String keyId = this.putKeyField(content, "keyId", SignUtil.getString("keyId", howToSign.getPaperName(), null), context, joinPoint);
                this.clientVerify(howToSign, (Signature)o, algorithm, keyId);
            }
            return o;
        }
        catch (Throwable th) {
            throw ConcreteHelper.getException(th);
        }
    }

    private void clientVerify(SignUtil.HowToSign howToSign, Signature signature, String algorithm, String keyId) throws IllegalAccessException {
        Assert.not(howToSign.getIronPenFactory(algorithm).getIronPen(howToSign.getPaperName()).verify(howToSign.getSerializer().serialize(this.signatureToMap(signature)), Base64.decodeBase64((String)signature.getSign()), algorithm, keyId), 1016, "client side verify failed.");
    }

    protected void setArgument(RuntimeContext context, MethodInvocation joinPoint, String parameterName, Object value) {
        AbstractUnit unit = ConcreteContext.getServiceContext().getCurrentUnit();
        for (AbstractParam param : unit.getParameters()) {
            if (!param.getName().equals(parameterName)) continue;
            joinPoint.getArguments()[param.getIndex()] = value;
            break;
        }
    }

    protected abstract String dataToString(byte[] var1);

    protected String methodToProperty(Method method) {
        if (method.getParameterTypes().length != 0) {
            return null;
        }
        if (method.getReturnType().equals(Void.TYPE) || method.getReturnType().equals(Void.class)) {
            return null;
        }
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return Common.lowerFirstChar((String)methodName.substring(3));
        }
        if (methodName.startsWith("is") && (method.getReturnType().equals(Boolean.TYPE) || method.getReturnType().equals(Boolean.class))) {
            return Common.lowerFirstChar((String)methodName.substring(2));
        }
        return null;
    }

    protected Map<String, Object> beanToMap(Object bean) throws InvocationTargetException, IllegalAccessException {
        Class<?> c = bean.getClass();
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        for (Method method : c.getMethods()) {
            String property = this.methodToProperty(method);
            if (property == null) continue;
            method.setAccessible(true);
            Object o = method.invoke(bean, new Object[0]);
            if (o == null) continue;
            objectMap.put(property, o);
        }
        return objectMap;
    }
}

