/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.executable.ExecutableValidator;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ConcreteServiceLoader;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.common.ViolationsFormatter;
import org.coodex.concrete.core.intercept.AbstractInterceptor;
import org.coodex.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanValidationInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BeanValidationInterceptor.class);
    private static final ViolationsFormatter DEFAULT_FORMMATER = new ViolationsFormatter(){

        @Override
        public <T> String format(Collection<ConstraintViolation<T>> violations) {
            StringBuilder buf = new StringBuilder();
            for (ConstraintViolation<T> violation : violations) {
                buf.append(violation.getMessage()).append("\n");
            }
            return buf.toString();
        }
    };
    private static final ServiceLoader<ViolationsFormatter> VIOLATIONS_FORMATTER_SPI = new ConcreteServiceLoader<ViolationsFormatter>(){

        @Override
        protected ViolationsFormatter getConcreteDefaultProvider() {
            return DEFAULT_FORMMATER;
        }
    };
    private ExecutableValidator executableValidator = null;
    private boolean hasProvider = true;

    private synchronized ExecutableValidator getValidator() {
        if (this.executableValidator == null && this.hasProvider) {
            try {
                this.executableValidator = Validation.buildDefaultValidatorFactory().getValidator().forExecutables();
            }
            catch (Throwable t) {
                this.hasProvider = false;
                log.warn("Failed to load validation provider: {}", (Object)t.getLocalizedMessage());
            }
        }
        return this.executableValidator;
    }

    public void checkViolations(Set<ConstraintViolation<Object>> constraintViolations) {
        if (constraintViolations.size() > 0) {
            throw new ConcreteException(1009, ((ViolationsFormatter)VIOLATIONS_FORMATTER_SPI.getInstance()).format(constraintViolations));
        }
    }

    @Override
    public int getOrder() {
        return 1000;
    }

    @Override
    public boolean accept(RuntimeContext context) {
        return ConcreteHelper.getProfile().getBool("aspect.bean.validation", true) && this.getValidator() != null;
    }

    @Override
    public void before(RuntimeContext context, MethodInvocation joinPoint) {
        this.checkViolations(this.getValidator().validateParameters(joinPoint.getThis(), context.getDeclaringMethod(), joinPoint.getArguments(), new Class[0]));
    }
}

