/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.api.Limiting;
import org.coodex.concrete.api.NotService;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.core.intercept.AbstractInterceptor;
import org.coodex.util.Profile;

public class MaximumConcurrencyInterceptor
extends AbstractInterceptor {
    private static final Profile MC_PROFILE = Profile.getProfile((String)"limiting.maximum.concurrency.properties");
    private static final Map<String, ConcurrencyStrategy> STRATEGIES = new HashMap<String, ConcurrencyStrategy>();

    @Override
    public int getOrder() {
        return 300;
    }

    @Override
    public boolean accept(RuntimeContext context) {
        return context.getDeclaringMethod().getAnnotation(NotService.class) == null && context.getAnnotation(Limiting.class) != null;
    }

    @Override
    public void before(RuntimeContext context, MethodInvocation joinPoint) {
        ConcurrencyStrategy strategy = this.getConcurrencyStrategy(context);
        if (strategy != null && !strategy.alloc()) {
            throw new ConcreteException(1014, new Object[0]);
        }
    }

    @Override
    public Object after(RuntimeContext context, MethodInvocation joinPoint, Object result) {
        this.release(context);
        return super.after(context, joinPoint, result);
    }

    private void release(RuntimeContext context) {
        ConcurrencyStrategy strategy = this.getConcurrencyStrategy(context);
        if (strategy != null) {
            strategy.release();
        }
    }

    @Override
    public Throwable onError(RuntimeContext context, MethodInvocation joinPoint, Throwable th) {
        this.release(context);
        return super.onError(context, joinPoint, th);
    }

    private ConcurrencyStrategy getConcurrencyStrategy(RuntimeContext context) {
        ConcurrencyStrategy strategy = null;
        Limiting limiting = context.getAnnotation(Limiting.class);
        if (limiting != null) {
            strategy = MaximumConcurrencyInterceptor.getStrategy(limiting.strategy());
        }
        return strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConcurrencyStrategy getStrategy(String strategyName) {
        Map<String, ConcurrencyStrategy> map = STRATEGIES;
        synchronized (map) {
            if (!STRATEGIES.containsKey(strategyName)) {
                ConcurrencyStrategy strategy = new ConcurrencyStrategy(strategyName);
                STRATEGIES.put(strategyName, strategy);
            }
        }
        return STRATEGIES.get(strategyName);
    }

    static class ConcurrencyStrategy {
        private final AtomicInteger counter = new AtomicInteger(0);
        private final String strategyName;

        public ConcurrencyStrategy(String strategyName) {
            this.strategyName = strategyName;
        }

        public synchronized boolean alloc() {
            if ((long)this.counter.get() < this.getMaximum()) {
                this.counter.incrementAndGet();
                return true;
            }
            return false;
        }

        public synchronized void release() {
            this.counter.decrementAndGet();
        }

        public long getMaximum() {
            return MC_PROFILE.getInt(this.strategyName + ".max", MC_PROFILE.getInt("max", Integer.MAX_VALUE));
        }
    }
}

