/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.api.AccessAllow;
import org.coodex.concrete.api.Domain;
import org.coodex.concrete.api.Safely;
import org.coodex.concrete.common.RBACHelper;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.core.intercept.AbstractInterceptor;
import org.coodex.util.Common;
import org.coodex.util.Profile;

public class RBACInterceptor
extends AbstractInterceptor {
    @Override
    public int getOrder() {
        return 9000;
    }

    @Override
    public boolean accept(RuntimeContext context) {
        return context.getAnnotation(AccessAllow.class) != null;
    }

    @Override
    public void before(RuntimeContext context, MethodInvocation joinPoint) {
        if (context.getDeclaringMethod() != null) {
            AccessAllow accessAllow;
            Domain owner;
            Profile profile = Profile.getProfile((String)(context.getModuleName() + ".properties"));
            String[] acl = profile.getStrList(context.getDeclaringMethod().getName() + "." + context.getDeclaringMethod().getParameterTypes().length);
            String domain = profile.getString("domain");
            if (domain == null && (owner = context.getAnnotation(Domain.class)) != null && !Common.isBlank((String)owner.value().trim())) {
                domain = owner.value();
            }
            if (acl == null && (accessAllow = context.getAnnotation(AccessAllow.class)) != null && (acl = accessAllow.roles()).length == 0) {
                acl = new String[]{"EVERYBODY"};
            }
            this.rbac(acl, domain, context.getAnnotation(Safely.class) != null);
        }
    }

    public void rbac(String[] acl, String domain, boolean safely) {
        RBACHelper.rbac(acl, domain, safely);
    }
}

