/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.messages;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.coodex.concrete.common.messages.Message;
import org.coodex.concrete.common.messages.PostOffice;
import org.coodex.concrete.common.messages.Subscriber;
import org.coodex.concrete.common.messages.Subscription;
import org.coodex.concrete.core.messages.SubscriberImpl;
import org.coodex.concurrent.ExecutorsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPostOffice
implements PostOffice {
    private final ExecutorService executorService = ExecutorsHelper.newSingleThreadExecutor();
    private static final Logger log = LoggerFactory.getLogger(AbstractPostOffice.class);
    private Set<SubscriberImpl> subscribers = new HashSet<SubscriberImpl>();

    protected final <T> void distribute(final Message<T> message) {
        if (message == null) {
            return;
        }
        for (final SubscriberImpl subscriber : this.subscribers) {
            if (!this.accept(message, subscriber.getSubscription())) continue;
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        subscriber.getSubscription().onMessage(message);
                    }
                    catch (Throwable throwable) {
                        log.warn("message [{}:{}] distribute failed.{}", new Object[]{message.getSubject(), message.getId(), throwable.getLocalizedMessage(), throwable});
                    }
                }
            });
        }
    }

    private boolean accept(Message message, Subscription subscription) {
        if (!message.getSubject().equals(subscription.getSubject())) {
            return false;
        }
        try {
            return subscription.getFilter() == null || subscription.getFilter().iWantIt(message);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public <T> Subscriber<T> subscribe(Subscription<T> subscription) {
        if (subscription == null) {
            throw new NullPointerException("subscription is null.");
        }
        for (SubscriberImpl s : this.subscribers) {
            if (!s.getSubscription().isSame(subscription)) continue;
            return s;
        }
        SubscriberImpl<T> subscriber = new SubscriberImpl<T>(subscription);
        this.subscribers.add(subscriber);
        return subscriber;
    }

    public synchronized void cancel(Subscriber subscriber) {
        if (subscriber instanceof SubscriberImpl) {
            this.subscribers.remove(subscriber);
        }
    }
}

