/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.signature;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.core.signature.RSAKeyStore;
import org.coodex.concrete.core.signature.SignUtil;

public class RSAKeyStoreDefaultImpl
implements RSAKeyStore {
    @Override
    public byte[] getPrivateKey(String paperName) {
        try {
            String keyId = SignUtil.getString("keyId", paperName, null);
            return this.loadKey(Arrays.asList("rsa.privateKey." + paperName + "." + keyId, "rsa.privateKey." + paperName, "rsa.privateKey." + keyId, "rsa.privateKey"), Arrays.asList(paperName + "." + keyId + ".pem", paperName + ".pem"));
        }
        catch (Throwable th) {
            throw new ConcreteException(99999, th.getLocalizedMessage(), th);
        }
    }

    private byte[] loadKey(List<String> properties, List<String> resources) throws IOException {
        String property;
        String s = null;
        Iterator<String> iterator = properties.iterator();
        while (iterator.hasNext() && (s = SignUtil.PROFILE.getString(property = iterator.next())) == null) {
        }
        if (s == null) {
            InputStream is = null;
            for (String resource : resources) {
                is = RSAKeyStoreDefaultImpl.class.getClassLoader().getResourceAsStream(resource);
                if (is == null) continue;
                break;
            }
            s = this.loadFromInputStream(is);
        }
        if (s == null) {
            return null;
        }
        return Base64.decodeBase64(s);
    }

    private String loadFromInputStream(InputStream is) throws IOException {
        String s;
        if (is == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder builder = new StringBuilder();
        while ((s = reader.readLine()) != null) {
            builder.append(s);
        }
        return builder.toString();
    }

    @Override
    public byte[] getPublicKey(String paperName, String keyId) {
        try {
            return this.loadKey(Arrays.asList("rsa.publicKey." + paperName + "." + keyId, "rsa.publicKey." + paperName, "rsa.publicKey." + keyId, "rsa.publicKey"), Arrays.asList(paperName + "." + keyId + ".crt", paperName + ".crt"));
        }
        catch (Throwable th) {
            throw new ConcreteException(99999, th.getLocalizedMessage(), th);
        }
    }
}

