/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.signature;

import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteServiceLoader;
import org.coodex.concrete.core.signature.AbstractIronPen;
import org.coodex.concrete.core.signature.RSAKeyStore;
import org.coodex.concrete.core.signature.RSAKeyStoreDefaultImpl;
import org.coodex.util.Common;
import org.coodex.util.RSACommon;
import org.coodex.util.ServiceLoader;

public class RSAPen
extends AbstractIronPen {
    private static final ServiceLoader<RSAKeyStore> RSA_KEY_STORE_PROVIDERS = new ConcreteServiceLoader<RSAKeyStore>(){

        @Override
        public RSAKeyStore getConcreteDefaultProvider() {
            return new RSAKeyStoreDefaultImpl();
        }
    };

    RSAPen(String paperName) {
        super(paperName);
    }

    private String nullToDefault(String algorithm) {
        return Common.isBlank((String)algorithm) ? "SHA256withRSA" : algorithm;
    }

    public byte[] sign(byte[] content, String algorithm, String keyId) {
        try {
            return RSACommon.sign((byte[])((RSAKeyStore)RSA_KEY_STORE_PROVIDERS.getInstance()).getPrivateKey(this.paperName), (byte[])content, (String)this.nullToDefault(algorithm));
        }
        catch (Throwable th) {
            throw new ConcreteException(99999, th.getLocalizedMessage(), th);
        }
    }

    public boolean verify(byte[] content, byte[] signature, String algorithm, String keyId) {
        try {
            return RSACommon.verify((byte[])((RSAKeyStore)RSA_KEY_STORE_PROVIDERS.getInstance()).getPublicKey(this.paperName, keyId), (byte[])content, (byte[])signature, (String)this.nullToDefault(algorithm));
        }
        catch (Throwable th) {
            throw new ConcreteException(99999, th.getLocalizedMessage(), th);
        }
    }
}

