/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.token.local;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.TokenManager;
import org.coodex.concrete.core.token.local.LocalToken;
import org.coodex.concurrent.ExecutorsHelper;

public class LocalTokenManager
implements TokenManager {
    static final Map<String, TokenWithFuture> TOKENS = new ConcurrentHashMap<String, TokenWithFuture>();
    private static final ScheduledExecutorService EXECUTOR = ExecutorsHelper.newSingleThreadScheduledExecutor();

    @Override
    public Token getToken(String id) {
        return this.getToken(id, false);
    }

    @Override
    public synchronized Token getToken(String id, boolean force) {
        if (id == null) {
            throw new NullPointerException("token id could NOT be NULL.");
        }
        TokenWithFuture tokenWithFuture = TOKENS.get(id);
        if (tokenWithFuture == null && force) {
            tokenWithFuture = new TokenWithFuture(new LocalToken(id));
            TOKENS.put(id, tokenWithFuture);
        }
        if (tokenWithFuture != null) {
            tokenWithFuture.active();
            return tokenWithFuture.token;
        }
        return null;
    }

    private static class TokenWithFuture {
        LocalToken token;
        private ScheduledFuture<?> handler = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void active() {
            long maxIdleTime = ConcreteHelper.getProfile().getLong("localTokenManager.maxIdleTime", 60L) * 60L * 1000L;
            if (maxIdleTime <= 0L) {
                maxIdleTime = 3600000L;
            }
            Runnable future = new Runnable(){

                @Override
                public void run() {
                    TokenWithFuture.this.token.invalidate();
                }
            };
            if (!EXECUTOR.isTerminated() && !EXECUTOR.isShutdown()) {
                if (this.handler == null) {
                    this.handler = EXECUTOR.schedule(future, maxIdleTime, TimeUnit.MILLISECONDS);
                } else if (this.token.isValid()) {
                    this.token.active();
                    try {
                        this.handler.cancel(true);
                    }
                    finally {
                        this.handler = EXECUTOR.schedule(future, maxIdleTime, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }

        public TokenWithFuture(LocalToken token) {
            this.token = token;
        }
    }
}

