/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.util.HashSet;
import java.util.Map;
import org.coodex.concrete.common.BeanProvider;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ConcreteServiceLoader;
import org.coodex.concrete.common.ConflictSolution;
import org.coodex.concrete.common.conflictsolutions.ThrowException;
import org.coodex.util.AcceptableServiceLoader;
import org.coodex.util.ServiceLoaderFacade;

public abstract class AbstractBeanProvider
implements BeanProvider {
    public static final String CREATE_BY_CONCRETE = "cbc_";
    private static final ConflictSolution DEFAULT_CONFLICT_SOLUTION = new ThrowException();
    private static final AcceptableServiceLoader<Class, ConflictSolution> SOLUTION_CONCRETE_SPI_FACADE = new AcceptableServiceLoader((ServiceLoaderFacade)new ConcreteServiceLoader<ConflictSolution>(){});

    private static final ConflictSolution getSolution(Class<?> clz) {
        ConflictSolution conflictSolution = (ConflictSolution)SOLUTION_CONCRETE_SPI_FACADE.getServiceInstance(clz);
        if (conflictSolution != null) {
            return conflictSolution;
        }
        try {
            Class<?> c = Class.forName(ConcreteHelper.getProfile().getString(ConflictSolution.class.getCanonicalName()));
            return (ConflictSolution)c.newInstance();
        }
        catch (Throwable throwable) {
            return DEFAULT_CONFLICT_SOLUTION;
        }
    }

    @Override
    public final <T> T getBean(Class<T> type) {
        Map<String, T> instanceMap = this.getBeansOfType(type);
        HashSet<String> keySet = new HashSet<String>(instanceMap.keySet());
        for (String name : keySet) {
            if (!name.startsWith(CREATE_BY_CONCRETE)) continue;
            instanceMap.remove(name);
        }
        switch (instanceMap.size()) {
            case 0: {
                throw new ConcreteException(1011, type.getName());
            }
            case 1: {
                return instanceMap.values().iterator().next();
            }
        }
        return AbstractBeanProvider.getSolution(type).conflict(instanceMap, type);
    }
}

