/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.coodex.concrete.common.Subjoin;
import org.coodex.util.Common;

public abstract class AbstractSubjoin
implements Subjoin {
    public static final String LOCALE = "CONCRETE-LOCATE";
    private Map<String, List<String>> stringMap = new HashMap<String, List<String>>();
    private Locale locale = Locale.getDefault();

    public AbstractSubjoin() {
        this(null);
    }

    public AbstractSubjoin(Map<String, String> map) {
        if (map == null) {
            return;
        }
        for (String key : map.keySet()) {
            String v = map.get(key);
            if (v == null) continue;
            if (key.equalsIgnoreCase(LOCALE)) {
                this.setLocale(this.forLanguageTag(v));
                continue;
            }
            this.set(key, Common.toArray((String)v, (String)"; ", new ArrayList()));
        }
    }

    protected abstract Locale forLanguageTag(String var1);

    protected abstract String toLanguageTag();

    public Locale getLocale() {
        return this.locale;
    }

    protected void setLocale(Locale locale) {
        if (locale != null) {
            this.locale = locale;
        }
    }

    public String get(String name) {
        return this.get(name, "; ");
    }

    public String get(String name, String split) {
        return Common.concat(this.getList(name), (String)split);
    }

    public List<String> getList(String name) {
        return this.stringMap.get(name);
    }

    public Set<String> keySet() {
        return this.stringMap.keySet();
    }

    public void set(String name, List<String> values) {
        this.stringMap.put(name, values);
    }

    public void add(String name, String value) {
        List<String> list = this.stringMap.get(name);
        if (list == null) {
            list = new ArrayList<String>();
            this.stringMap.put(name, list);
        }
        list.add(value);
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(LOCALE, this.toLanguageTag());
        for (String key : this.keySet()) {
            map.put(key, this.get(key));
        }
        return map;
    }
}

