/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import org.coodex.concrete.api.Abstract;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.api.MicroService;
import org.coodex.concrete.api.NotService;
import org.coodex.concrete.api.Priority;
import org.coodex.concrete.common.AbstractErrorCodes;
import org.coodex.concrete.common.ConcreteClassFilter;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteServiceLoader;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.DefinitionContextImpl;
import org.coodex.concrete.common.ModuleMaker;
import org.coodex.concrete.common.struct.AbstractModule;
import org.coodex.concrete.common.struct.AbstractUnit;
import org.coodex.concurrent.ExecutorsHelper;
import org.coodex.util.ClassNameFilter;
import org.coodex.util.Common;
import org.coodex.util.Profile;
import org.coodex.util.ReflectHelper;
import org.coodex.util.ServiceLoader;
import org.coodex.util.Singleton;

public class ConcreteHelper {
    public static final String VERSION = "0.2.2";
    private static Singleton<ExecutorService> executorService = new Singleton((Singleton.Builder)new Singleton.Builder<ExecutorService>(){

        public ExecutorService build() {
            return ExecutorsHelper.newPriorityThreadPool((int)ConcreteHelper.getProfile().getInt("service.executor.corePoolSize", 0), (int)ConcreteHelper.getProfile().getInt("service.executor.maximumPoolSize", Integer.MAX_VALUE), (long)ConcreteHelper.getProfile().getInt("service.executor.keepAliveTime", 60));
        }
    });
    private static final ClassNameFilter CONCRETE_SERVICE_INTERFACE_FILTER = new ConcreteClassFilter(){

        @Override
        protected boolean accept(Class<?> clazz) {
            return clazz != null && clazz.isInterface() && ConcreteService.class.isAssignableFrom(clazz) && clazz.getAnnotation(MicroService.class) != null && clazz.getAnnotation(Abstract.class) == null;
        }
    };
    private static final ServiceLoader<ModuleMaker> MODULE_MAKERS = new ConcreteServiceLoader<ModuleMaker>(){};

    private static Profile getDefaultProfile(String tag) {
        return Profile.getProfile((String)(tag + ".properties"));
    }

    public static Profile getProfile() {
        return ConcreteHelper.getProfile("concrete");
    }

    public static Profile getProfile(String tag) {
        return ConcreteHelper.getProfile(tag, null);
    }

    public static Profile getProfile(String tag, String sub) {
        return Common.isBlank((String)sub) ? ConcreteHelper.getDefaultProfile(tag) : Profile.getProfile((String)(tag + "." + sub + ".properties"));
    }

    public static String getString(String tag, String module, String key) {
        Profile profile = ConcreteHelper.getProfile(tag, module);
        String value = profile.getString(key);
        if (value == null && !Common.isBlank((String)module) && (value = (profile = ConcreteHelper.getProfile(tag)).getString(String.format("%s.%s", module, key))) == null) {
            value = profile.getString(key);
        }
        if (value == null) {
            profile = ConcreteHelper.getProfile();
            if (!Common.isBlank((String)module)) {
                value = profile.getString(String.format("%s.%s.%s", tag, module, key));
            }
            if (value == null) {
                value = profile.getString(String.format("%s.%s", tag, key));
            }
        }
        return value;
    }

    public static ExecutorService getExecutor() {
        return (ExecutorService)executorService.getInstance();
    }

    public static Method[] getAllMethod(Class<?> serviceClass) {
        HashSet<Method> methods = new HashSet<Method>();
        ConcreteHelper.loadAllMethod(serviceClass, methods, null);
        return methods.toArray(new Method[0]);
    }

    private static void loadAllMethod(Class<?> clz, Set<Method> methods, Set<Class> classes) {
        if (clz == null) {
            return;
        }
        if (methods == null) {
            methods = new HashSet<Method>();
        }
        if (classes == null) {
            classes = new HashSet<Class>();
        }
        if (classes.contains(clz)) {
            return;
        }
        classes.add(clz);
        for (Method method : clz.getMethods()) {
            if (method.getAnnotation(NotService.class) != null) continue;
            methods.add(method);
        }
    }

    public static String getServiceName(Class<?> clz) {
        if (clz == null || !ConcreteService.class.isAssignableFrom(clz)) {
            return null;
        }
        MicroService concreteService = clz.getAnnotation(MicroService.class);
        if (concreteService == null) {
            return null;
        }
        return Common.isBlank((String)concreteService.value()) ? (clz.getAnnotation(Abstract.class) != null ? clz.getSimpleName() : clz.getCanonicalName()) : concreteService.value();
    }

    public static String getMethodName(Method method) {
        if (method == null) {
            return null;
        }
        MicroService concreteService = method.getAnnotation(MicroService.class);
        if (concreteService == null) {
            return method.getName();
        }
        return Common.isBlank((String)concreteService.value()) ? method.getName() : concreteService.value();
    }

    public static void foreachService(ReflectHelper.Processor processor, String ... packages) {
        ReflectHelper.foreachClass((ReflectHelper.Processor)processor, (ClassNameFilter)CONCRETE_SERVICE_INTERFACE_FILTER, (String[])packages);
    }

    public static void foreachClassInPackages(ReflectHelper.Processor processor, String ... packages) {
        if (packages == null || packages.length == 0) {
            packages = ConcreteHelper.getApiPackages();
        }
        int l = packages.length;
        for (int i = 0; i < l; ++i) {
            for (int j = i + 1; j < l; ++j) {
                String p1 = packages[i];
                String p2 = packages[j];
                if (p1.length() <= p2.length()) continue;
                packages[i] = p2;
                packages[j] = p1;
            }
        }
        ArrayList<String> forSearch = new ArrayList<String>();
        block2: for (String pkg : packages) {
            for (String searchPath : forSearch) {
                if (!Common.isBlank((String)searchPath) && !pkg.equals(searchPath) && !pkg.startsWith(searchPath + ".")) continue;
                continue block2;
            }
            forSearch.add(pkg);
        }
        ReflectHelper.foreachClass((ReflectHelper.Processor)processor, (ClassNameFilter)new ConcreteClassFilter(){

            @Override
            protected boolean accept(Class<?> clazz) {
                return ConcreteHelper.isConcreteService(clazz) || AbstractErrorCodes.class.isAssignableFrom(clazz);
            }
        }, (String[])forSearch.toArray(new String[0]));
    }

    public static final <MODULE extends AbstractModule> List<MODULE> loadModules(String desc, String ... packages) {
        return ConcreteHelper.loadModules(ConcreteHelper.getInstance(desc), packages);
    }

    public static boolean isConcreteService(Class<?> clz) {
        return ConcreteService.class.isAssignableFrom(clz) && clz.getAnnotation(MicroService.class) != null && clz.getAnnotation(Abstract.class) == null;
    }

    private static ModuleMaker getInstance(String desc) {
        if (MODULE_MAKERS.getAllInstances().size() == 0) {
            throw new RuntimeException("No service provider for " + ModuleMaker.class.getName());
        }
        for (ModuleMaker moduleMaker : MODULE_MAKERS.getAllInstances()) {
            if (!moduleMaker.isAccept(desc)) continue;
            return moduleMaker;
        }
        throw new RuntimeException("No service provider supported '" + desc + "' ");
    }

    public static <MODULE extends AbstractModule> MODULE loadModule(String desc, Class<? extends ConcreteService> serviceClass) {
        return ConcreteHelper.loadModule(ConcreteHelper.getInstance(desc), serviceClass);
    }

    public static <MODULE extends AbstractModule> MODULE loadModule(ModuleMaker<MODULE> moduleMaker, Class<? extends ConcreteService> serviceClass) {
        return (MODULE)moduleMaker.make(serviceClass);
    }

    private static <MODULE extends AbstractModule> List<MODULE> loadModules(final ModuleMaker<MODULE> maker, String ... packages) {
        final HashMap moduleMap = new HashMap();
        ConcreteHelper.foreachService(new ReflectHelper.Processor(){

            public void process(Class<?> serviceClass) {
                AbstractModule module = maker.make(serviceClass);
                Class key = module.getInterfaceClass();
                AbstractModule exists = (AbstractModule)moduleMap.get(key);
                if (exists != null) {
                    throw new RuntimeException(String.format("Module %s duplicated. %s & %s", key, exists.getInterfaceClass().getName(), module.getInterfaceClass().getName()));
                }
                moduleMap.put(key, module);
            }
        }, packages);
        ArrayList moduleList = new ArrayList(moduleMap.values());
        Collections.sort(moduleList);
        return moduleList;
    }

    public static int getPriority(Method method, Class<?> clz) {
        DefinitionContext context = ConcreteHelper.getContext(method, clz);
        Priority priority = (Priority)context.getAnnotation(Priority.class);
        return priority == null ? 5 : Math.max(1, Math.min(10, priority.value()));
    }

    public static int getPriority(AbstractUnit unit) {
        return ConcreteHelper.getPriority(unit.getMethod(), unit.getDeclaringModule().getInterfaceClass());
    }

    public static DefinitionContext getContext(Method method, Class<?> clz) {
        return ConcreteHelper.getContext(method, clz, new Stack());
    }

    private static DefinitionContext getContext(Method method, Class<?> clz, Stack<Class<?>> stack) {
        if (clz == null) {
            return null;
        }
        if (ConcreteService.class.equals(clz) || !ConcreteService.class.isAssignableFrom(clz)) {
            return null;
        }
        if (stack.contains(clz)) {
            return null;
        }
        stack.add(clz);
        if (clz.getAnnotation(MicroService.class) != null && clz.getAnnotation(Abstract.class) == null) {
            DefinitionContextImpl context = new DefinitionContextImpl();
            context.setDeclaringClass(clz);
            Method unitMethod = ConcreteHelper.findMethod(method, clz);
            if (unitMethod == null) {
                return null;
            }
            context.setDeclaringMethod(unitMethod);
            return context;
        }
        for (Class<?> clazz : clz.getInterfaces()) {
            DefinitionContext context = ConcreteHelper.getContext(method, clazz, stack);
            if (context == null) continue;
            return context;
        }
        return ConcreteHelper.getContext(method, clz.getSuperclass(), stack);
    }

    private static Method findMethod(Method method, Class<?> clz) {
        return ConcreteHelper.findMethod(method, clz, new Stack());
    }

    private static Method findMethod(Method method, Class<?> clz, Collection<Class<?>> stack) {
        if (stack.contains(clz)) {
            return null;
        }
        stack.add(clz);
        try {
            return clz.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            for (Class<?> clazz : clz.getInterfaces()) {
                Method m = ConcreteHelper.findMethod(method, clazz, stack);
                if (m == null) continue;
                return m;
            }
            return null;
        }
    }

    public static final ConcreteException findException(Throwable th) {
        if (th == null) {
            return null;
        }
        for (Throwable t = th; t != null; t = t.getCause()) {
            if (!(t instanceof ConcreteException)) continue;
            return (ConcreteException)t;
        }
        return null;
    }

    public static final ConcreteException getException(Throwable th) {
        ConcreteException concreteException = ConcreteHelper.findException(th);
        if (concreteException == null) {
            concreteException = new ConcreteException(99999, th.getLocalizedMessage(), th);
        }
        return concreteException;
    }

    public static List<Class> inheritedChain(Class root, Class sub) {
        if (!ConcreteService.class.isAssignableFrom(root)) {
            return null;
        }
        if (root.equals(sub)) {
            return Arrays.asList(new Class[0]);
        }
        for (Class<?> c : sub.getInterfaces()) {
            List<Class> subChain;
            if (!root.isAssignableFrom(c) || (subChain = ConcreteHelper.inheritedChain(root, c)) == null) continue;
            ArrayList<Class> inheritedChain = new ArrayList<Class>();
            inheritedChain.add(c);
            inheritedChain.addAll(subChain);
            return inheritedChain;
        }
        return null;
    }

    public static String[] getApiPackages() {
        return ConcreteHelper.getProfile().getStrList("concrete.api.packages", ",", new String[0]);
    }

    public static String[] getRemoteApiPackages() {
        return ConcreteHelper.getProfile().getStrList("concrete.remoteapi.packages", ",", new String[0]);
    }

    public static String getAppSet() {
        return ConcreteHelper.getProfile().getString("concrete.appSet");
    }

    public static String devModelKey(String module) {
        return "org.coodex.concrete" + (Common.isBlank((String)module) ? "" : "." + module) + ".devMode";
    }

    public static boolean isDevModel(String module) {
        return System.getProperty(ConcreteHelper.devModelKey(module)) != null || System.getProperty(ConcreteHelper.devModelKey(null)) != null;
    }
}

