/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common;

import java.util.Map;
import org.coodex.concrete.common.BeanProviderFacade;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.util.ServiceLoaderFacade;

public abstract class ConcreteServiceLoader<T>
extends ServiceLoaderFacade<T> {
    private boolean init = false;

    protected ConcreteServiceLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadInstances() {
        ConcreteServiceLoader concreteServiceLoader = this;
        synchronized (concreteServiceLoader) {
            super.loadInstances();
            if (!this.init) {
                try {
                    Map instances = this.$getInstances();
                    Map beans = BeanProviderFacade.getBeanProvider().getBeansOfType(this.getInterfaceClass());
                    if (beans != null && beans.size() > 0) {
                        for (String key : beans.keySet()) {
                            Object t = beans.get(key);
                            if (t == null || instances.values().contains(t)) continue;
                            instances.put(key, t);
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.init = true;
            }
        }
    }

    protected T conflict(Class<? extends T> providerClass, Map<String, T> map) {
        String key = ConcreteHelper.getProfile().getString(providerClass + ".provider");
        return (T)(map.containsKey(key) ? map.get(key) : super.conflict(providerClass, map));
    }

    protected T conflict() {
        String key = ConcreteHelper.getProfile().getString(this.getInterfaceClass().getCanonicalName() + ".provider");
        Map instances = this.$getInstances();
        return (T)(instances.containsKey(key) ? instances.get(key) : super.conflict());
    }

    protected final T getDefaultProviderFromProfile() {
        String key = ConcreteHelper.getProfile().getString(this.getInterfaceClass().getCanonicalName() + ".default");
        Map instances = this.$getInstances();
        return instances.containsKey(key) ? (T)instances.get(key) : null;
    }

    protected T getConcreteDefaultProvider() {
        return (T)super.getDefaultProvider();
    }

    public final T getDefaultProvider() {
        T instance = this.getDefaultProviderFromProfile();
        return instance == null ? this.getConcreteDefaultProvider() : instance;
    }
}

