/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common.conflictsolutions;

import java.util.HashMap;
import java.util.Map;
import org.coodex.concrete.common.AccountFactory;
import org.coodex.concrete.common.AccountFactoryAggregation;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.conflictsolutions.AbstractConflictSolution;

public class AccountFactoryAggregationFilter
extends AbstractConflictSolution {
    public boolean accept(Class param) {
        return AccountFactory.class.isAssignableFrom(param);
    }

    @Override
    protected <T> Map<String, T> doFilter(Map<String, T> beans, Class<T> clz) {
        HashMap<String, T> map = new HashMap<String, T>();
        for (String key : beans.keySet()) {
            T accountFactory = beans.get(key);
            if (accountFactory == null || !AccountFactoryAggregation.class.isAssignableFrom(accountFactory.getClass())) continue;
            map.put(key, accountFactory);
        }
        if (map.size() == 0) {
            throw new ConcreteException(1011, AccountFactoryAggregation.class);
        }
        return map;
    }
}

