/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.common.count;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.bytecode.SignatureAttribute;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ConcreteServiceLoader;
import org.coodex.concurrent.ExecutorsHelper;
import org.coodex.count.CountFacade;
import org.coodex.count.Countable;
import org.coodex.count.Counter;
import org.coodex.count.CounterChain;
import org.coodex.count.Segmentation;
import org.coodex.count.SegmentedCounter;
import org.coodex.util.ServiceLoader;
import org.coodex.util.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountFacadeProvider
implements CountFacade {
    private static final Logger log = LoggerFactory.getLogger(CountFacadeProvider.class);
    private static final AtomicInteger atomicInteger = new AtomicInteger(0);
    private Map<Class, CounterChain> chainMap;
    private static final ServiceLoader<Counter> counterProvider = new ConcreteServiceLoader<Counter>(){};
    public static final ScheduledExecutorService SCHEDULED_EXECUTOR_SERVICE = ExecutorsHelper.newScheduledThreadPool((int)ConcreteHelper.getProfile().getInt("counter.thread.pool.size", 10));

    private void buildMap() {
        TypeVariable t = Counter.class.getTypeParameters()[0];
        this.chainMap = new HashMap<Class, CounterChain>();
        for (Counter counter : counterProvider.getAllInstances()) {
            Type type = TypeHelper.solve(t, (Type[])new Type[]{counter.getClass()});
            if (type instanceof Class) {
                try {
                    this.getCounterChain((Class)type).addCounter(counter);
                    if (!(counter instanceof SegmentedCounter)) continue;
                    this.schedule((SegmentedCounter)counter);
                }
                catch (Throwable th) {
                    log.warn("error occurred: {}", (Object)th.getLocalizedMessage(), (Object)th);
                }
                continue;
            }
            log.warn("type nonsupport: {}", (Object)type);
        }
    }

    private void schedule(final SegmentedCounter counter) {
        long next;
        Segmentation segmentation = counter.getSegmentation();
        if (segmentation != null && (next = segmentation.next()) > System.currentTimeMillis()) {
            SCHEDULED_EXECUTOR_SERVICE.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SegmentedCounter segmentedCounter = counter;
                        synchronized (segmentedCounter) {
                            counter.slice();
                        }
                    }
                    finally {
                        CountFacadeProvider.this.schedule(counter);
                    }
                }
            }, next - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CounterChain getCounterChain(Class clz) throws IllegalAccessException, CannotCompileException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Map<Class, CounterChain> map = this.chainMap;
        synchronized (map) {
            if (!this.chainMap.keySet().contains(clz)) {
                this.chainMap.put(clz, this.newCounterChain(clz));
            }
        }
        return this.chainMap.get(clz);
    }

    private CounterChain newCounterChain(Class clz) throws CannotCompileException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        ClassPool classPool = ClassPool.getDefault();
        String className = String.format("CounterChain$%s$%08X", clz.getSimpleName(), atomicInteger.incrementAndGet());
        CtClass newClass = classPool.makeClass(className, classPool.getOrNull(CounterChain.class.getName()));
        newClass.getClassFile().setVersionToJava5();
        newClass.setGenericSignature(new SignatureAttribute.ClassSignature(null, new SignatureAttribute.ClassType(clz.getName()), null).encode());
        CtConstructor spiConstructor = new CtConstructor(null, newClass);
        spiConstructor.setBody("{super();}");
        CtMethod ctMethod = CtMethod.make((String)String.format("protected %s getThreadPool(){ return %s.SCHEDULED_EXECUTOR_SERVICE;}", Executor.class.getName(), CountFacadeProvider.class.getName()), (CtClass)newClass);
        newClass.addMethod(ctMethod);
        newClass.addConstructor(spiConstructor);
        return (CounterChain)newClass.toClass().getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public <T extends Countable> void count(T value) {
        Object object;
        if (this.chainMap == null) {
            object = CountFacadeProvider.class;
            // MONITORENTER : org.coodex.concrete.common.count.CountFacadeProvider.class
            if (this.chainMap == null) {
                this.buildMap();
            }
            // MONITOREXIT : object
        }
        if (value == null) return;
        object = this.chainMap.keySet().iterator();
        while (object.hasNext()) {
            Class clz = (Class)object.next();
            if (!clz.isAssignableFrom(value.getClass())) continue;
            this.chainMap.get(clz).count(value);
        }
    }
}

