/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.core.intercept.AbstractInterceptor;
import org.coodex.concrete.core.intercept.ConcreteInterceptor;
import org.coodex.concrete.core.intercept.ConcreteSyncInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSyncInterceptor
extends AbstractInterceptor
implements ConcreteSyncInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractSyncInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        RuntimeContext context = AbstractSyncInterceptor.getContext(invocation);
        if (context == null || !this.accept(context)) {
            return invocation.proceed();
        }
        this.before(context, invocation);
        try {
            Object result = this.around(context, invocation);
            try {
                this.after(context, invocation, result);
            }
            catch (Throwable t) {
                log.warn("Error occurred in afterAdvice. {}", (Object)t.getLocalizedMessage(), (Object)t);
            }
            finally {
                return result;
            }
        }
        catch (ConcreteException ce) {
            throw ce;
        }
        catch (Throwable t) {
            Throwable t2 = this.onError(context, invocation, t);
            throw t2 == null ? t : t2;
        }
    }

    @Override
    public Object around(RuntimeContext context, MethodInvocation joinPoint) throws Throwable {
        return joinPoint.proceed();
    }

    protected ConcreteSyncInterceptor asyncToSync(final ConcreteInterceptor interceptor) {
        return new AbstractSyncInterceptor(){

            @Override
            public int getOrder() {
                return interceptor.getOrder();
            }

            @Override
            public boolean accept(RuntimeContext context) {
                return interceptor.accept(context);
            }

            @Override
            public void before(RuntimeContext context, MethodInvocation joinPoint) {
                interceptor.before(context, joinPoint);
            }

            @Override
            public Object after(RuntimeContext context, MethodInvocation joinPoint, Object result) {
                return interceptor.after(context, joinPoint, result);
            }

            @Override
            public Throwable onError(RuntimeContext context, MethodInvocation joinPoint, Throwable th) {
                return interceptor.onError(context, joinPoint, th);
            }
        };
    }
}

