/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import org.aopalliance.intercept.MethodInvocation;
import org.coodex.closure.CallableClosure;
import org.coodex.concrete.api.LogAtomic;
import org.coodex.concrete.api.OperationLog;
import org.coodex.concrete.common.AbstractMessageFacade;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.AccountID;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteServiceLoader;
import org.coodex.concrete.common.LogFormatter;
import org.coodex.concrete.common.MessagePatternLoader;
import org.coodex.concrete.common.NamedAccount;
import org.coodex.concrete.common.OperationLogger;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.core.intercept.AbstractSyncInterceptor;
import org.coodex.concrete.core.token.TokenWrapper;
import org.coodex.util.Common;
import org.coodex.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLogInterceptor
extends AbstractSyncInterceptor {
    private static final Logger log = LoggerFactory.getLogger(OperationLogInterceptor.class);
    private static final OperationLogger DEFAULT_LOGGER = new OperationLogger(){

        public void log(String accountId, String accountName, String category, String subClass, String message) {
            log.info("accountId: {}; accountName: {}; category: {}; subClass: {}; message: {}", new Object[]{accountId, accountName, category, subClass, message});
        }
    };
    private static final ServiceLoader<OperationLogger> LOGGER_SERVICE_LOADER = new ConcreteServiceLoader<OperationLogger>(){

        @Override
        public OperationLogger getConcreteDefaultProvider() {
            return DEFAULT_LOGGER;
        }
    };
    static ThreadLocal<Account<? extends AccountID>> OPERATOR = new ThreadLocal();

    @Override
    public int getOrder() {
        return 2000;
    }

    @Override
    public boolean accept(RuntimeContext context) {
        return context.getAnnotation(OperationLog.class) != null || context.getAnnotation(LogAtomic.class) != null;
    }

    private Account<? extends AccountID> getOperator() {
        try {
            Account account = TokenWrapper.getInstance().currentAccount();
            return account;
        }
        catch (Throwable th) {
            Account<? extends AccountID> account = OPERATOR.get();
            return account;
        }
        finally {
            OPERATOR.remove();
        }
    }

    @Override
    public Object around(final RuntimeContext context, final MethodInvocation joinPoint) throws Throwable {
        return ConcreteContext.runWithContext((ServiceContext)new AtomServiceContext(ConcreteContext.getServiceContext()), new CallableClosure(){

            public Object call() throws Throwable {
                return OperationLogInterceptor.this.$$after(context, joinPoint, joinPoint.proceed());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object $$after(RuntimeContext context, MethodInvocation joinPoint, Object result) {
        try {
            LogAtomic logAtomic;
            String accountName;
            Account<? extends AccountID> account = this.getOperator();
            String accountId = account == null ? null : account.getId().serialize();
            String string = accountName = account == null ? "Anonymous" : null;
            if (account != null) {
                accountName = account instanceof NamedAccount ? ((NamedAccount)account).getName() : "Unknown";
            }
            String category = null;
            String subClass = null;
            String messageTemplate = null;
            LogAtomic.LoggingType loggingType = LogAtomic.LoggingType.DATA;
            Class formatterClass = LogFormatter.class;
            Class patternLoaderClass = MessagePatternLoader.class;
            Class loggerClass = OperationLogger.class;
            OperationLog operationLog = context.getAnnotation(OperationLog.class);
            if (operationLog != null) {
                category = operationLog.category();
                formatterClass = operationLog.formatterClass();
                patternLoaderClass = operationLog.patternLoaderClass();
                loggerClass = operationLog.loggerClass();
            }
            if ((logAtomic = context.getAnnotation(LogAtomic.class)) != null) {
                if (!Common.isBlank((String)logAtomic.category())) {
                    category = logAtomic.category();
                }
                subClass = logAtomic.subClass();
                loggingType = logAtomic.loggingType();
                messageTemplate = logAtomic.message();
            }
            if (Common.isBlank(subClass)) {
                subClass = context.getDeclaringMethod().getName();
            }
            if (this.isDoLog(loggingType)) {
                OperationLogInterceptor.getLogger(loggerClass).log(accountId, accountName, category, subClass, OperationLogInterceptor.buildLog(category, subClass, messageTemplate, formatterClass, patternLoaderClass));
            }
        }
        catch (Throwable th) {
            log.warn("{}", (Object)th.getLocalizedMessage(), (Object)th);
        }
        finally {
            return super.after(context, joinPoint, result);
        }
    }

    private boolean isDoLog(LogAtomic.LoggingType loggingType) {
        boolean doLog = false;
        switch (loggingType) {
            case NO: {
                break;
            }
            case DATA: {
                doLog = ConcreteContext.getLoggingData().size() > 0;
                break;
            }
            case ALWAYS: {
                doLog = true;
            }
        }
        return doLog;
    }

    private static String buildLog(String category, String subClass, String messageTemplate, Class<? extends LogFormatter> formatterClass, Class<? extends MessagePatternLoader> patternLoaderClass) {
        String key = null;
        String template = null;
        if (messageTemplate != null && messageTemplate.startsWith("{") && messageTemplate.endsWith("}")) {
            key = Common.trim((String)messageTemplate, (char[])new char[]{'{', '}', ' '});
        } else if (messageTemplate != null) {
            template = messageTemplate;
        }
        if (template == null) {
            if (key == null) {
                key = OperationLogInterceptor.getMessageKey(category, subClass);
            }
            template = AbstractMessageFacade.getPatternLoader(patternLoaderClass).getMessageTemplate(key);
        }
        return AbstractMessageFacade.getLogFormatter(formatterClass).format(messageTemplate, ConcreteContext.getLoggingData());
    }

    private static String getMessageKey(String category, String subClass) {
        if (Common.isBlank((String)category) && Common.isBlank((String)subClass)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (!Common.isBlank((String)category)) {
            builder.append(category);
        }
        if (!Common.isBlank((String)subClass)) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(subClass);
        }
        return builder.toString();
    }

    private static OperationLogger getLogger(Class<? extends OperationLogger> loggerClass) {
        return loggerClass == null || loggerClass == OperationLogger.class ? (OperationLogger)LOGGER_SERVICE_LOADER.getInstance() : (OperationLogger)LOGGER_SERVICE_LOADER.getInstance(loggerClass);
    }

    public static class AtomServiceContext
    extends ServiceContext {
        public AtomServiceContext(ServiceContext context) {
            this.caller = context.getCaller();
            this.token = context.getToken();
            this.model = context.getModel();
            this.subjoin = context.getSubjoin();
            this.side = context.getSide();
            this.currentUnit = context.getCurrentUnit();
            this.courier = context.getCourier();
        }
    }
}

