/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.intercept;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.api.NotService;
import org.coodex.concrete.api.ServiceTiming;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.common.ServiceTimingChecker;
import org.coodex.concrete.core.intercept.AbstractInterceptor;
import org.coodex.concrete.core.intercept.timecheckers.ByTimeRange;
import org.coodex.concrete.core.intercept.timecheckers.ByWorkDay;
import org.coodex.util.Common;
import org.coodex.util.Profile;
import org.coodex.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTimingInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ServiceTimingInterceptor.class);
    private static final Map<String, String> DEFAULT_CHECKERS = new HashMap<String, String>();
    private static final ServiceTimingChecker ALL_ALLOWED_CHECKER;

    @Override
    public boolean accept(RuntimeContext context) {
        return this.isTimingLimitService(context);
    }

    @Override
    public int getOrder() {
        return 200;
    }

    @Override
    public void before(RuntimeContext context, MethodInvocation joinPoint) {
        IF.not(ServiceTimingInterceptor.getValidator(context.getAnnotation(ServiceTiming.class)).isAllowed(), 1013, new Object[0]);
    }

    public boolean isTimingLimitService(RuntimeContext context) {
        return context.getDeclaringMethod().getAnnotation(NotService.class) == null && context.getAnnotation(ServiceTiming.class) != null;
    }

    private static ServiceTimingChecker loadCheckerInstance(String label) {
        Profile profile = Profile.getProfile((String)"serviceTiming.properties");
        String type = profile.getString(label + ".type");
        String className = null;
        if (Common.isBlank((String)type)) {
            log.warn("ServiceTiming validation rule not defined. : {} ", (Object)label);
            return ALL_ALLOWED_CHECKER;
        }
        className = DEFAULT_CHECKERS.get((type = type.trim()).toUpperCase());
        if (className == null) {
            className = type;
        }
        try {
            Class<?> clz = Class.forName(className);
            Object o = clz.newInstance();
            for (Field f : ReflectHelper.getAllDeclaredFields(clz)) {
                String s;
                f.setAccessible(true);
                if (Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers()) || !String.class.equals(f.getType()) || (s = profile.getString(label + "." + f.getName())) == null) continue;
                f.set(o, s.trim());
            }
            return (ServiceTimingChecker)o;
        }
        catch (Throwable t) {
            log.warn("error occurred in ServiceTimingChecker initialization. {} :{}", (Object)t.getClass().getCanonicalName(), (Object)t.getLocalizedMessage());
            return ALL_ALLOWED_CHECKER;
        }
    }

    private static ServiceTimingChecker getValidator(ServiceTiming serviceTiming) {
        if (serviceTiming == null || serviceTiming.value().length == 0) {
            return ALL_ALLOWED_CHECKER;
        }
        return new ServiceTimingCheckerChain(serviceTiming);
    }

    static {
        DEFAULT_CHECKERS.put("TIMERANGE", ByTimeRange.class.getCanonicalName());
        DEFAULT_CHECKERS.put("WORKDAY", ByWorkDay.class.getCanonicalName());
        ALL_ALLOWED_CHECKER = new ServiceTimingChecker(){

            public boolean isAllowed() {
                return true;
            }
        };
    }

    private static class ServiceTimingCheckerChain
    implements ServiceTimingChecker {
        private List<ServiceTimingChecker> chain = new ArrayList<ServiceTimingChecker>();

        ServiceTimingCheckerChain(ServiceTiming serviceTiming) {
            HashSet<String> keys = new HashSet<String>();
            for (String s : serviceTiming.value()) {
                if (Common.isBlank((String)s) || Common.isBlank((String)s.trim()) || keys.contains(s = s.trim())) continue;
                keys.add(s);
                this.chain.add(ServiceTimingInterceptor.loadCheckerInstance(s));
            }
        }

        public boolean isAllowed() {
            for (ServiceTimingChecker checker : this.chain) {
                if (checker.isAllowed()) continue;
                return false;
            }
            return true;
        }
    }
}

