/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.core.messages;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.coodex.concrete.common.messages.Message;
import org.coodex.util.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessage<T>
implements Message<T> {
    private static final transient Logger log = LoggerFactory.getLogger(AbstractMessage.class);
    private final String id = Common.getUUIDStr();
    private final String host;
    private final String subject;
    private final T body;

    public AbstractMessage(String subject, T body) {
        this.host = null;
        this.subject = subject;
        this.body = body;
    }

    public String getId() {
        return this.id;
    }

    public String getHost() {
        return this.host;
    }

    public String getSubject() {
        return this.subject;
    }

    public T getBody() {
        try {
            if (this.body instanceof Serializable) {
                return (T)Common.deepCopy((Serializable)((Serializable)this.body));
            }
        }
        catch (NotSerializableException notSerializableException) {
        }
        catch (Throwable throwable) {
            log.warn("Unable copy message body.{}", (Object)throwable.getLocalizedMessage(), (Object)throwable);
        }
        return this.body;
    }
}

